package to.then.kie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Profile {
    
    private Properties properties = new Properties();
    private Set<Repository> repositories = new LinkedHashSet();
    private Map<String, String> aliases = new LinkedHashMap();

    public Properties getProperties() {
        return properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Set<Repository> getRepositories() {
        return repositories;
    }

    public void setRepositories(Set<Repository> repositories) {
        this.repositories = repositories;
    }

    public Map<String, String> getAliases() {
        return aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    @Override
    public String toString() {
        return "Profile{properties=" + properties + ", repositories=" + repositories + '}';
    }
    
}
