package to.then.kie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Repository {
    
    private String id;
    private URI url;

    public Repository() {
    }

    public Repository(String id, String url) {
        this.id = id;
        try {
            this.url = new URI(url);
        } catch (URISyntaxException ex) {
            throw new IllegalArgumentException(url, ex);
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public URI getUrl() {
        return url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }
    
    public RemoteRepository toRemoteRepository() {
        return new RemoteRepository.Builder(getId(), "default", getUrl().toString()).setPolicy(new RepositoryPolicy(true, "always", "ignore")).build();
    }
    
    public static Repository fromRemoteRepository(RemoteRepository remote) {
        return new Repository(remote.getId(), remote.getUrl());
    }
    

    @Override
    public String toString() {
        return "Repository{" + "id=" + id + ", url=" + url + '}';
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.id);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Repository other = (Repository) obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return true;
    }
    
    
    
}
