/*
 * Decompiled with CFR 0.152.
 */
package to.then.kie;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.AWSLambdaClient;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.KinesisEvent;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.inject.InjectionException;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.log4j.Logger;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyJackson2Provider;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.scanner.embedder.MavenSettings;
import to.then.kie.KieRepository;
import to.then.kie.model.Module;
import to.then.kie.model.Settings;

public class KieFunction {
    private static final Logger log = Logger.getLogger(KieFunction.class);
    private final AmazonS3 s3;
    private final ObjectMapper json;
    private final KieServices kie;
    private final Map<Class, Object> providers;
    private final KieRepository repository;

    public KieFunction(KieRepository repository, AmazonS3 s3, AWSLambda lambda, Client http) {
        this.repository = repository;
        this.json = new ObjectMapper().findAndRegisterModules().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.s3 = s3;
        this.kie = KieServices.Factory.get();
        this.providers = new LinkedHashMap<Class, Object>();
        this.providers.put(AWSLambda.class, lambda);
        this.providers.put(AmazonS3.class, new AmazonS3Client());
        this.providers.put(AmazonSQS.class, new AmazonSQSClient());
        this.providers.put(Client.class, http);
        this.providers.put(ObjectMapper.class, this.json);
        this.providers.put(Logger.class, log);
        this.unpackRepository("/maven.zip");
    }

    public KieFunction(AmazonS3 s3, AWSLambda lambda, Client http) {
        this(new KieRepository(s3), s3, lambda, http);
    }

    public KieFunction() {
        this((AmazonS3)new AmazonS3Client(), (AWSLambda)new AWSLambdaClient(), (Client)new ResteasyClientBuilder().httpEngine((ClientHttpEngine)new ApacheHttpClient4Engine((HttpClient)HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build())).register(ResteasyJackson2Provider.class).build());
    }

    public void apply(KinesisEvent event, Context context) {
        try {
            log.info((Object)this.json.writeValueAsString((Object)event));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        event.getRecords().forEach(record -> {
            try {
                JsonNode request = this.json.readTree(record.getKinesis().getData().array());
                AmazonS3URI settingsUri = new AmazonS3URI(request.get("settings").textValue());
                Settings settings = this.getSettings(settingsUri);
                List profiles = null;
                if (request.has("profiles")) {
                    profiles = (List)this.json.convertValue((Object)request.get("profiles"), List.class);
                }
                String command = request.get("command").textValue();
                ObjectNode result = this.json.createObjectNode();
                Set<RemoteRepository> repositories = settings.getRemoteRepositories(profiles);
                Properties properties = settings.getProperties(profiles);
                Map<String, String> aliases = settings.getAliases(profiles);
                String releaseId = request.get("releaseId").textValue();
                releaseId = aliases.getOrDefault(releaseId, releaseId);
                result.put("status", "ok");
                switch (command) {
                    case "deploy": {
                        Module module = (Module)this.json.convertValue((Object)request.get("module"), Module.class);
                        KieBuilder builder = this.deploy(this.releaseId(releaseId), module, repositories);
                        if (builder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                            result.put("status", "error");
                        }
                        if (builder.getResults().getMessages().isEmpty()) break;
                        result.set("messages", (JsonNode)this.json.convertValue((Object)builder.getResults().getMessages(), ArrayNode.class));
                        break;
                    }
                    case "insert": {
                        ArrayNode inserts = (ArrayNode)request.get("objects");
                        this.insert(this.releaseId(releaseId), inserts, properties, repositories);
                    }
                }
                log.info((Object)this.json.writeValueAsString((Object)result));
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        });
    }

    private Settings getSettings(AmazonS3URI uri) {
        S3Object s3Object = this.s3.getObject(uri.getBucket(), uri.getKey());
        Settings settings = null;
        try (S3ObjectInputStream objectIn = s3Object.getObjectContent();){
            settings = (Settings)this.json.readValue((InputStream)objectIn, Settings.class);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return settings;
    }

    protected KieBuilder deploy(ReleaseId releaseId, Module module, Collection<RemoteRepository> repositories) {
        KieBuilder builder = this.build(releaseId, module, repositories);
        if (!builder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            this.repository.putKieModule((AbstractKieModule)builder.getKieModule(), module.getDistribution().getRepository().toRemoteRepository());
        } else {
            log.error((Object)builder.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}));
        }
        return builder;
    }

    protected KieBuilder build(ReleaseId releaseId, Module module, Collection<RemoteRepository> repositories) {
        LinkedList<ReleaseId> dependencyIds = new LinkedList<ReleaseId>();
        if (module.getDependencies() != null) {
            module.getDependencies().forEach(dependency -> {
                this.repository.resolveDependencies((String)dependency, repositories);
                ReleaseId dependencyId = this.releaseId((String)dependency);
                dependencyIds.add(dependencyId);
            });
        }
        KieFileSystem files = this.kie.newKieFileSystem();
        KieModuleModel kModuleModel = KieFunction.configureKieModuleModel(this.kie.newKieModuleModel(), module.getName(), releaseId, dependencyIds, module.getIncludes());
        files.writeKModuleXML(kModuleModel.toXML());
        files.writePomXML(this.getPomXml(releaseId, dependencyIds));
        if (module.getResources() != null) {
            module.getResources().forEach((path, resource) -> files.write("src/main/resources/" + path, resource));
        }
        KieBuilderImpl builder = (KieBuilderImpl)this.kie.newKieBuilder(files);
        builder.getPomModel().getDependencies().addAll(dependencyIds);
        builder.buildAll();
        return builder;
    }

    protected StatelessKieSession newStatelessKieSession(Properties properties, AbstractKieModule kmodule, KieContainer kcontainer) {
        StatelessKieSession session = kcontainer.newStatelessKieSession();
        KnowledgeBuilderImpl kb = (KnowledgeBuilderImpl)kmodule.getKnowledgeBuilderForKieBase((String)kmodule.getKieModuleModel().getKieBaseModels().keySet().iterator().next());
        kb.getGlobals().forEach((key, value) -> {
            if (this.providers.containsKey(value)) {
                session.setGlobal(key, this.providers.get(value));
            } else if (Properties.class.equals(value)) {
                session.setGlobal(key, (Object)properties);
            } else {
                try {
                    Class<?> type = kcontainer.getClassLoader().loadClass(value.getName());
                    for (Constructor<?> constructor : type.getConstructors()) {
                        if (constructor.getAnnotation(Inject.class) == null) continue;
                        try {
                            Object[] args = new Object[constructor.getParameterCount()];
                            for (int index = 0; index < constructor.getParameterCount(); ++index) {
                                Class<?> parameterType = constructor.getParameterTypes()[index];
                                if (this.providers.get(parameterType) != null) {
                                    args[index] = this.providers.get(parameterType);
                                    continue;
                                }
                                if (Properties.class.equals(parameterType)) {
                                    args[index] = properties;
                                    continue;
                                }
                                throw new InjectionException(type.getName() + ": " + parameterType);
                            }
                            session.setGlobal(key, constructor.newInstance(args));
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return session;
    }

    protected String getPomXml(ReleaseId releaseId, List<ReleaseId> dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n" + "  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n" + "  <version>" + releaseId.getVersion() + "</version>\n" + "\n";
        if (dependencies != null && dependencies.size() > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected void insert(ReleaseId releaseId, ArrayNode inserts, Properties properties, Set<RemoteRepository> repositories) {
        log.info((Object)releaseId.toExternalForm());
        log.info((Object)inserts);
        AbstractKieModule kmodule = this.repository.getKieModule(releaseId, repositories);
        KieContainer kcontainer = this.kie.newKieContainer(kmodule.getReleaseId());
        StatelessKieSession session = this.newStatelessKieSession(properties, kmodule, kcontainer);
        LinkedList objects = new LinkedList();
        inserts.elements().forEachRemaining(node -> node.fieldNames().forEachRemaining(className -> {
            try {
                Object insert = this.json.convertValue((Object)node.get(className), kcontainer.getClassLoader().loadClass((String)className));
                objects.add(insert);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }));
        session.execute(this.kie.getCommands().newInsertElements(objects));
    }

    private ReleaseId releaseId(String releaseId) {
        String[] split = releaseId.split(":");
        return this.kie.newReleaseId(split[0], split[1], split[2]);
    }

    protected static KieModuleModel configureKieModuleModel(KieModuleModel kModuleModel, String name, ReleaseId releaseId, Collection<ReleaseId> dependencies, Collection<String> includes) {
        KieBaseModel kieBaseModel = kModuleModel.newKieBaseModel(name).setDefault(true);
        if (includes != null) {
            includes.forEach(include -> kieBaseModel.addInclude(include));
        }
        kieBaseModel.newKieSessionModel(name + ".stateless").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
        KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kModuleModel);
        return kModuleModel;
    }

    private void unpackRepository(String resourceName) {
        try (ZipInputStream stream = new ZipInputStream(KieFunction.class.getResourceAsStream(resourceName));){
            ZipEntry entry;
            String outdir = MavenSettings.getSettings().getLocalRepository();
            while ((entry = stream.getNextEntry()) != null) {
                File outpath;
                if (entry.getSize() == 0L) {
                    outpath = new File(outdir + "/" + entry.getName());
                    outpath.mkdirs();
                    continue;
                }
                outpath = new File(outdir + "/" + entry.getName());
                outpath.createNewFile();
                FileOutputStream output = new FileOutputStream(outpath);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)stream, (OutputStream)output);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    output.close();
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

