/*
 * Decompiled with CFR 0.152.
 */
package to.then.kie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import to.then.kie.model.Distribution;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Module {
    private Distribution distribution;
    private Map<String, String> resources;
    private Set<String> dependencies;
    private Set<String> includes;
    private String name;

    public Module(String name) {
        this.name = name;
    }

    public Module() {
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getResources() {
        return this.resources;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public void setResources(Map<String, String> resources) {
        this.resources = resources;
    }

    public void setDependencies(Set<String> dependencies) {
        this.dependencies = dependencies;
    }

    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    public Module withDistribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public Module withResource(String path, String resource) {
        if (this.resources == null) {
            this.resources = new LinkedHashMap<String, String>();
        }
        this.resources.put(path, resource);
        return this;
    }

    public Module withDependency(String dependency) {
        if (this.dependencies == null) {
            this.dependencies = new LinkedHashSet<String>();
        }
        this.dependencies.add(dependency);
        return this;
    }

    public Module withInclude(String include) {
        if (this.includes == null) {
            this.includes = new LinkedHashSet<String>();
        }
        this.includes.add(include);
        return this;
    }

    public String toString() {
        return "Module{distribution=" + this.distribution + ", resources=" + this.resources + ", dependencies=" + this.dependencies + ", includes=" + this.includes + ", name=" + this.name + '}';
    }
}

