/*
 * Decompiled with CFR 0.152.
 */
package to.then.kie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Repository {
    private String id;
    private URI url;

    public Repository() {
    }

    public Repository(String id, String url) {
        this.id = id;
        try {
            this.url = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(url, ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public RemoteRepository toRemoteRepository() {
        return new RemoteRepository.Builder(this.getId(), "default", this.getUrl().toString()).setPolicy(new RepositoryPolicy(true, "always", "ignore")).build();
    }

    public static Repository fromRemoteRepository(RemoteRepository remote) {
        return new Repository(remote.getId(), remote.getUrl());
    }

    public String toString() {
        return "Repository{id=" + this.id + ", url=" + this.url + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Repository other = (Repository)obj;
        return Objects.equals(this.id, other.id);
    }
}

