/*
 * Decompiled with CFR 0.152.
 */
package to.then.kie.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.eclipse.aether.repository.RemoteRepository;
import to.then.kie.model.Profile;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Settings {
    private Map<String, Profile> profiles;
    private List<String> activeProfiles;

    public Map<String, Profile> getProfiles() {
        return this.profiles;
    }

    public List<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    public void setProfiles(Map<String, Profile> profiles) {
        this.profiles = profiles;
    }

    public void setActiveProfiles(List<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public Settings withProfile(String id, Profile profile) {
        if (this.profiles == null) {
            this.profiles = new LinkedHashMap<String, Profile>();
        }
        this.profiles.put(id, profile);
        return this;
    }

    public Settings withActiveProfile(String id) {
        if (this.activeProfiles == null) {
            this.activeProfiles = new LinkedList<String>();
        }
        this.activeProfiles.add(id);
        return this;
    }

    public Map<String, String> getAliases(Collection<String> profileIds) {
        LinkedHashMap<String, String> aliases = new LinkedHashMap<String, String>();
        this.getProfiles(profileIds).forEach(profile -> aliases.putAll(profile.getAliases()));
        return aliases;
    }

    public Properties getProperties(Collection<String> profileIds) {
        Properties properties = new Properties();
        this.getProfiles(profileIds).forEach(profile -> properties.putAll((Map<?, ?>)profile.getProperties()));
        return properties;
    }

    public Set<RemoteRepository> getRemoteRepositories(Collection<String> profileIds) {
        LinkedHashSet<RemoteRepository> repositories = new LinkedHashSet<RemoteRepository>();
        this.getProfiles(profileIds).forEach(profile -> profile.getRepositories().forEach(repository -> repositories.add(repository.toRemoteRepository())));
        return repositories;
    }

    private List<Profile> getProfiles(Collection<String> profileIds) {
        LinkedList<Profile> selectedProfiles = new LinkedList<Profile>();
        Optional.ofNullable(this.activeProfiles).orElse(Collections.EMPTY_LIST).forEach(id -> selectedProfiles.add(this.profiles.getOrDefault(id, new Profile())));
        if (profileIds != null) {
            profileIds.forEach(id -> selectedProfiles.add(this.profiles.getOrDefault(id, new Profile())));
        }
        return selectedProfiles;
    }

    public String toString() {
        return "Settings{profiles=" + this.profiles + ", activeProfiles=" + this.activeProfiles + '}';
    }
}

