/*
 * Decompiled with CFR 0.152.
 */
package to.then.maven.wagon.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;

public final class AmazonS3Wagon
extends AbstractWagon {
    private final Logger log = Logger.getLogger(AmazonS3Wagon.class);
    private final AmazonS3 s3;

    public AmazonS3Wagon(AmazonS3 s3) {
        this.s3 = s3;
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
    }

    protected void closeConnection() throws ConnectionException {
    }

    public void get(String key, File file) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getIfModifiedSince(key, file, null);
    }

    public boolean getIfNewer(String key, File file, long lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        return this.getIfModifiedSince(key, file, new Date(lastModified));
    }

    private boolean getIfModifiedSince(String path, File file, Date lastModified) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        GetObjectRequest getObject = new GetObjectRequest(this.repository.getHost(), this.getKey(path));
        try {
            S3Object s3Object;
            if (lastModified != null) {
                getObject.setModifiedSinceConstraint(lastModified);
            }
            if ((s3Object = this.s3.getObject(getObject)) != null) {
                this.log.info((Object)s3Object.getObjectMetadata().getContentLength());
                try (FileOutputStream fileOut = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)s3Object.getObjectContent(), (OutputStream)fileOut);
                }
                return true;
            }
            return false;
        }
        catch (AmazonS3Exception ex) {
            if (ex.getErrorCode().equals("NoSuchKey") || ex.getErrorCode().equals("AccessDenied")) {
                this.log.warn((Object)("s3://" + getObject.getBucketName() + "/" + getObject.getKey()), (Throwable)ex);
                throw new ResourceDoesNotExistException("s3://" + getObject.getBucketName() + "/" + getObject.getKey(), (Throwable)ex);
            }
            throw new TransferFailedException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new TransferFailedException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void put(File file, String path) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            PutObjectRequest putObject = new PutObjectRequest(this.repository.getHost(), this.getKey(path), file);
            this.s3.putObject(putObject);
        }
        catch (AmazonS3Exception ex) {
            throw new AuthorizationException(ex.getErrorCode(), (Throwable)ex);
        }
    }

    private String getKey(String path) {
        return this.repository.getBasedir().substring(1) + "/" + path;
    }
}

