/*
 * Decompiled with CFR 0.152.
 */
package com.donger.oss.aliyun.service;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.donger.oss.aliyun.config.OSSConfigProperties;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AliyunOssTemplate
implements InitializingBean {
    private final OSSConfigProperties ossConfigProperties;
    private final OSSClient ossClient;

    public Map getPolicyWithOutCallback() {
        long expireEndTime = System.currentTimeMillis() + (long)(this.ossConfigProperties.getExpire() * 1000);
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", this.ossConfigProperties.getDir());
        String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.ossClient.calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessid", this.ossConfigProperties.getAccessId());
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", this.ossConfigProperties.getDir());
        respMap.put("host", this.ossConfigProperties.getHost());
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        return respMap;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.ossConfigProperties.getAccessId(), (String)"Access ID\u4e3a\u7a7a");
        Assert.hasText((String)this.ossConfigProperties.getDir(), (String)"Dir \u4e3a\u7a7a");
        Assert.hasText((String)this.ossConfigProperties.getHost(), (String)"Hsot \u4e3a\u7a7a");
    }

    public AliyunOssTemplate(OSSConfigProperties ossConfigProperties, OSSClient ossClient) {
        this.ossConfigProperties = ossConfigProperties;
        this.ossClient = ossClient;
    }
}

