package com.donger.api.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.donger.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 菜单管理
 * </p>
 *
 * @author xyx
 * @since 2019-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SysMenu extends BaseEntity<SysMenu> {

    public static final long LEVEL_ONE_MENU = 0L;
    public static final long SENSITIVE_MENU_ID = 31L;
    private static final long serialVersionUID = 1L;
    @TableId(value = "menu_id")
    private Long menuId;

    /**
     * 父菜单ID，一级菜单为0
     */
    private Long parentId;


    /**
     * 菜单名称
     */
    private String title;


    /**
     * 是否隐藏 0: 隐藏 1: 显示
     */
    private Integer hidden;

    /**
     * 菜单URL
     */
    private String path;


    /**
     * 路由名称
     */
    private String name;
    /**
     * 是否隐藏 子路由  0 隐藏 1：显示
     */
    private Integer hideChildrenInMenu;

    /**
     * 授权(多个用逗号分隔，如：user:list,user:create)
     */
    private String perms;

    /**
     * 类型   0：目录   1：菜单   2：按钮
     */
    private Integer type;

    /**
     * 菜单图标
     */
    private String icon;

    /**
     * 排序
     */
    private Integer orderNum;

    @TableLogic
    private String delFlag;

    /**
     * 父菜单名称
     */
    @TableField(exist = false)
    private String parentName;

    @TableField(exist = false)
    private List<SysMenu> children;

}
