package com.donger.api.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.donger.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 系统用户
 * </p>
 *
 * @author xyx
 * @since 2019-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SysUser extends BaseEntity<SysUser> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "user_id")
    private Long userId;

    /**
     * 用户名
     */
//    @NotBlank(message = "用户名不能为空")
    private String username;

    /**
     * 密码
     */
//    @NotBlank(message = "密码不能为空")
    private String password;

    /**
     * 状态  0：禁用   1：正常
     */
    private Integer status;

    private String avatar;

    private String phone;


    private Long deptId;

    @TableField(exist = false)
    private String deptName;

    @TableLogic
    private String delFlag;


    /**
     * 角色列表
     */
    @TableField(exist = false)
    private List<SysRole> roleList;


}
