package com.donger.api.sys.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.donger.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 角色
 * </p>
 *
 * @author xyx
 * @since 2019-01-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SysRole extends BaseEntity<SysRole> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "role_id")
    private Long roleId;

    /**
     * 角色名称
     */
//    @NotBlank(message = "角色名称不能为空")
    private String roleName;
    /**
     * 角色标识
     */
//    @NotBlank(message = "角色代码不能为空")
    private String roleCode;

    private Long deptId;

    /**
     * 数据权限类型
     */
//    @NotBlank(message = "数据权限类型不能为空")
    private String dsType;

    /**
     * 数据权限范围
     */
    private String dsScope;

    @TableField(exist = false)
    private List<String> dsScopeList;

    @TableField(exist = false)
    private List<Long> menuIdList;

    @TableLogic
    private String delFlag;


}
