package com.donger.api.sys.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.donger.api.sys.entity.SysMenu;
import com.donger.api.sys.entity.SysUser;
import com.donger.api.sys.entity.UserDto;
import com.donger.api.sys.entity.UserInfo;

import java.util.List;

/**
 * <p>
 * 系统用户 服务类
 * </p>
 *
 * @author xyx
 * @since 2019-01-12
 */
public interface ISysUserService extends IService<SysUser> {


    IPage getUserWithRolePage(Page page, QueryWrapper<SysUser> queryWrapper);

    /**
     * 查询用户信息
     *
     * @param sysUser 用户信息
     * @return 用户信息
     */
    UserInfo findUserInfo(SysUser sysUser);

    /**
     * 根据用户ID 查询用户权限
     *
     * @param userId 用户ID
     * @return 用户权限列表
     */
    List<String> findPermissionsByUserId(Long userId);

    /**
     * 更新密码
     *
     * @param currentUserId 当前用ID
     * @param password      原密码
     * @param newPassword   新密码
     * @return true 更新成功 false 更新失败
     */
    boolean updatePassword(Long currentUserId, String password, String newPassword);

    /**
     * 查询当前用户菜单ID
     *
     * @param currentUserId 当前用户
     * @return 用户菜单ID列表
     */
    List<SysMenu> queryMenuByUserId(Long currentUserId);

    /**
     * 保存用户信息
     *
     * @param user 用户信息
     * @return 保存标识
     */
    Boolean saveUser(UserDto user);

    /**
     * 更新用户信息
     *
     * @param user 用户信息
     * @return 成功表示
     */
    Boolean updateUserById(UserDto user);

    Boolean deleteUserById(Long userId);
}
