/*
 * Decompiled with CFR 0.152.
 */
package com.donger.minio;

import com.donger.minio.MinioProperties;
import com.donger.minio.service.MinioTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={MinioProperties.class})
@Configuration
public class MinioAutoConfiguration {
    private final MinioProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={MinioTemplate.class})
    @ConditionalOnProperty(name={"minio.url"})
    MinioTemplate minioTemplate() {
        return new MinioTemplate(this.properties.getUrl(), this.properties.getAccessKey(), this.properties.getSecretKey());
    }

    public MinioAutoConfiguration(MinioProperties properties) {
        this.properties = properties;
    }
}

