/*
 * Decompiled with CFR 0.152.
 */
package com.donger.minio.service;

import com.donger.minio.vo.MinioItem;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.Result;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MinioTemplate
implements InitializingBean {
    private final String endpoint;
    private final String accessKey;
    private final String secretKey;
    private MinioClient client;

    public void createBucket(String bucketName) {
        if (!this.client.bucketExists(bucketName)) {
            this.client.makeBucket(bucketName);
        }
    }

    public List<Bucket> getAllBuckets() {
        return this.client.listBuckets();
    }

    public Optional<Bucket> getBucket(String bucketName) {
        return this.client.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst();
    }

    public void removeBucket(String bucketName) {
        this.client.removeBucket(bucketName);
    }

    public List<MinioItem> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) {
        ArrayList<MinioItem> objectList = new ArrayList<MinioItem>();
        Iterable objectsIterator = this.client.listObjects(bucketName, prefix, recursive);
        while (objectsIterator.iterator().hasNext()) {
            objectList.add(new MinioItem((Item)((Result)objectsIterator.iterator().next()).get()));
        }
        return objectList;
    }

    public String getObjectURL(String bucketName, String objectName, Integer expires) {
        return this.client.presignedGetObject(bucketName, objectName, expires);
    }

    public InputStream getObject(String bucketName, String objectName) {
        return this.client.getObject(bucketName, objectName);
    }

    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        this.client.putObject(bucketName, objectName, stream, (long)stream.available(), "application/octet-stream");
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) throws Exception {
        this.client.putObject(bucketName, objectName, stream, size, contextType);
    }

    public ObjectStat getObjectInfo(String bucketName, String objectName) throws Exception {
        return this.client.statObject(bucketName, objectName);
    }

    public void removeObject(String bucketName, String objectName) throws Exception {
        this.client.removeObject(bucketName, objectName);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.endpoint, (String)"Minio url \u4e3a\u7a7a");
        Assert.hasText((String)this.accessKey, (String)"Minio accessKey\u4e3a\u7a7a");
        Assert.hasText((String)this.secretKey, (String)"Minio secretKey\u4e3a\u7a7a");
        this.client = new MinioClient(this.endpoint, this.accessKey, this.secretKey);
    }

    public MinioTemplate(String endpoint, String accessKey, String secretKey) {
        this.endpoint = endpoint;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }
}

