package top.doudou.base.stream;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;

/**
 * @Description 关闭流工具类
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-22 9:21
 * @Version V1.0
 */
@Slf4j
public class StreamCloseUtils {

    /**
     * 关闭输出流
     * @param outputStream
     */
    public static void closeStream(OutputStream outputStream){
        if( null != outputStream){
            try {
                outputStream.close();
            } catch (IOException e) {
                log.error("close outputStream error");
                e.printStackTrace();
            }
        }
    }

    /**
     * 关闭输入流
     * @param inputStream
     */
    public static void closeStream(InputStream inputStream){
        if( null != inputStream){
            try {
                inputStream.close();
            } catch (IOException e) {
                log.error("close inputStream error");
                e.printStackTrace();
            }
        }
    }

    /**
     * 关闭输入流
     * @param channel
     */
    public static void closeChannel(Channel channel){
        if( null != channel){
            try {
                channel.close();
            } catch (IOException e) {
                log.error("close Channel error");
                e.printStackTrace();
            }
        }
    }
}
