package top.doudou.base.config;

import org.apache.commons.logging.impl.LogFactoryImpl;
import org.springframework.context.annotation.Configuration;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.io.PrintStream;

/**
 * 把在程序中的System.out.print()的信息自动转成日志信息
 * @author 傻男人<244191347@qq.com>
 * @create 2020-09-18 14:56
 */
@Configuration
public class StdoutListener implements ServletContextListener {

    @Override
    public void contextDestroyed(ServletContextEvent event) {
    }

    private void log(Object info) {
        LogFactoryImpl.getLog(getClass()).info(info);
    }

    @Override
    public void contextInitialized(ServletContextEvent event) {
        PrintStream printStream = new PrintStream(System.out) {
            @Override
            public void println(boolean x) {
                log(Boolean.valueOf(x));
            }
            @Override
            public void println(char x) {
                log(Character.valueOf(x));
            }
            @Override
            public void println(char[] x) {
                log(x == null ? null : new String(x));
            }
            @Override
            public void println(double x) {
                log(Double.valueOf(x));
            }
            @Override
            public void println(float x) {
                log(Float.valueOf(x));
            }
            @Override
            public void println(int x) {
                log(Integer.valueOf(x));
            }
            @Override
            public void println(long x) {
                log(x);
            }
            @Override
            public void println(Object x) {
                log(x);
            }
            @Override
            public void println(String x) {
                log(x);
            }
        };
        System.setOut(printStream);
        System.setErr(printStream);
    }
}