package top.doudou.base.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 带条件的分页查询
 * @author 傻男人<244191347@qq.com>
 * @create 2018-09-30 14:56
 */
@Data
@ApiModel("带条件的分页查询")
public class ConditionPageInfo<T> extends PageInfo implements Serializable {
    private static final long serialVersionUID = 7926666149245633548L;

    @ApiModelProperty(value = "查询条件")
    private T query;

    public ConditionPageInfo(){}

    public ConditionPageInfo(Integer pageIndex, Integer pageSize, T query){
        super(pageIndex,pageSize);
        this.query=query;
    }

    public ConditionPageInfo(Integer pageIndex, Long pageSize, T query){
        super(pageIndex,pageSize);
        this.query=query;
    }

    public ConditionPageInfo(PageInfo pageInfo, T query){
        super(pageInfo.getPageIndex(),pageInfo.getPageSize());
        this.query=query;
    }
}
