package top.doudou.base.random;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2020/4/30 14:57
 * @Version: 1.0
 * @Description:
 */
public class RandomUtils {

    public static final String NUM_LETTER_CODE = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LETTER_CODE = "abcdefghijkllmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String NUM_CODE = "0123456789";

    public static String randomTime(){
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static String randomUUID(){
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String randomUUID(int len){
        return UUID.randomUUID().toString().replace("-", "").substring(len);
    }

    /**
     * 生成制定范围内的随机数
     *
     * @param scopeMin
     * @param scopeMax
     * @return
     */
    public static int randomInt(int scopeMin, int scopeMax) {
        Random random = new Random();
        return (random.nextInt(scopeMax) % (scopeMax - scopeMin + 1) + scopeMin);
    }

    /**
     * 返回固定长度的数字
     *
     * @param len
     * @return
     */
    public static String number(int len) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; i++) {
            sb.append(NUM_CODE.charAt(random.nextInt(NUM_CODE.length())));
        }
        return sb.toString();
    }

    /**
     * 返回一个定长的随机字符串(只包含大小写字母、数字)
     *
     * @param len 随机字符串长度
     * @return 随机字符串
     */
    public static String random(int len) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; i++) {
            sb.append(NUM_LETTER_CODE.charAt(random.nextInt(NUM_LETTER_CODE.length())));
        }
        return sb.toString();
    }

    /**
     * 返回一个定长的随机字符串(只包含大小写字母)
     *
     * @param len 随机字符串长度
     * @return 随机字符串
     */
    public static String randomStr(int len) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; i++) {
            sb.append(LETTER_CODE.charAt(random.nextInt(LETTER_CODE.length())));
        }
        return sb.toString();
    }

    /**
     * 返回一个定长的随机纯小写字母字符串
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String randomLowerStr(int length) {
        return randomStr(length).toLowerCase();
    }

    /**
     *返回一个定长的随机纯大写字母字符串
     * @param length 随机字符串长度
     * @return 随机字符串
     */
    public static String randomUpperStr(int length) {
        return randomStr(length).toUpperCase();
    }

    /**
     * 生成一个定长的纯0字符串
     *
     * @param length 字符串长度
     * @return 纯0字符串
     */
    public static String zeroString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            sb.append('0');
        }
        return sb.toString();
    }

}
