package top.doudou.base.util;

import top.doudou.base.exception.NotFoundFileException;
import top.doudou.base.stream.StreamCloseUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;

/**
 * @Description 文件读取工具类
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-10-22 11:16
 * @Version V1.0
 */
public class FileReadUtil {

    /**
     * 读取文件的内容
     * @param file 文件路径
     * @throws FileNotFoundException
     * @return 返回以行为单位的数组数据
     */
    public static Object[] read(String file) throws FileNotFoundException {
        File file1 = new File(file);
        if(!file1.exists()){
            throw new NotFoundFileException("{}文件不存在",file);
        }
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            return reader.lines().toArray();
        }finally {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(fileReader);
        }
    }

}
