package top.doudou.base.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author  傻男人<244191347@qq.com>
 * @version 1.0
 * @createTime 2019-05-08-15:59
 */
public class ChineseCharacterUtil {

    /**
     *  获取汉字拼音--全部大写
     *
     * @param chinese 汉字
     * @return 全拼大写的字符串
     */
    public static String getUpperCase(String chinese){
        return convertChinese2Pinyin(chinese,true).toUpperCase();
    }

    /**
     *  获取汉字拼音--全部小写
     *
     * @param chinese 汉字
     * @return 全拼小写的字符串
     */
    public static  String getLowerCase(String chinese){
        return convertChinese2Pinyin(chinese,true).toLowerCase();
    }

    /**
     *  获取汉字拼音的首字母
     *
     * @param chinese 汉字
     * @return 拼音的首字母
     */
    public static  String getInitials(String chinese){
        return convertChinese2Pinyin(chinese,false);
    }

    /**
     *  获取汉字拼音--首字母大写
     *
     * @param chinese 汉字
     * @return 拼音首字母大写
     */
    public static  String getChineseFirstUpper(String chinese){
        return convertChinese2Pinyin(chinese,null);
    }

    /**
     * 将汉字转成拼音
     * <P>
     * 取首字母或全拼
     *
     * @param chinese 汉字字符串
     * @param isFull 是否全拼 true:表示全拼 false表示：首字母  null 拼音首字母大写
     *
     * @return 拼音
     */
    private static String convertChinese2Pinyin(String chinese, Boolean isFull){
        /***
         * ^[\u2E80-\u9FFF]+$ 匹配所有东亚区的语言
         * ^[\u4E00-\u9FFF]+$ 匹配简体和繁体
         * ^[\u4E00-\u9FA5]+$ 匹配简体
         */
        String regExp="^[\u4E00-\u9FFF]+$";
        StringBuffer sb=new StringBuffer();
        if(chinese==null||"".equals(chinese.trim())){
            return "";
        }
        String pinyin="";
        for(int i=0;i<chinese.length();i++){
            char unit=chinese.charAt(i);
            //是汉字，则转拼音
            if(match(String.valueOf(unit),regExp)){
                pinyin=convertSingleHanzi2Pinyin(unit);
                if(null == isFull){
                    sb.append(StrUtils.firstToUpperCase(pinyin));
                }else if(isFull){
                    sb.append(pinyin);
                } else{
                    sb.append(pinyin.charAt(0));
                }
            }else{
                sb.append(unit);
            }
        }
        return sb.toString();
    }

    /**
     * 将单个汉字转成拼音
     *
     * @param hanzi 汉字字符
     *
     * @return 拼音
     */
    private static String convertSingleHanzi2Pinyin(char hanzi){
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        String[] res;
        StringBuffer sb=new StringBuffer();
        try {
            res = PinyinHelper.toHanyuPinyinStringArray(hanzi,outputFormat);
            //对于多音字，只用第一个拼音
            sb.append(res[0]);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        return sb.toString();
    }

    /***
     * 匹配
     * <P>
     * 根据字符和正则表达式进行匹配
     *
     * @param str 源字符串
     * @param regex 正则表达式
     *
     * @return true：匹配成功  false：匹配失败
     */
    private static boolean match(String str,String regex){
        Pattern pattern= Pattern.compile(regex);
        Matcher matcher=pattern.matcher(str);
        return matcher.find();
    }


    /**
         * 根据正则表达式判断字符是否为汉字
         */
    public static boolean isContainChinese( String str) {
        String regex = "[\u4e00-\u9fa5]";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(str);
        return match.find();
    }



}
