package top.doudou.base.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import top.doudou.base.stream.StreamCloseUtils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-22 9:46
 * @Version V1.0
 */
public class StrUtils {
    private static final String REPLACE_STR = "\\{\\}";

    /**
     *  字符替换
     * @param format  需要替换的源字符
     * @param arguments  替换的参数
     * @return  替换后的字符
     */
    public static String strReplace(String format,Object... arguments){
        return strReplace(format,REPLACE_STR,arguments);
    }

    /**
     *  字符替换
     * @param format  需要替换的源字符
     * @param replace  需要替换源字符的哪个字符
     * @param arguments  替换的参数
     * @return  替换后的字符
     */
    public static String strReplace(String format,String replace,Object... arguments){
        if(StringUtils.isBlank(format)){
            return format;
        }
        Matcher m = Pattern.compile(replace).matcher(format);
        int i = 0;
        while (m.find() && i < arguments.length) {
            format = format.replaceFirst(replace, String.valueOf(arguments[i++]));
        }
        return format;
    }

    /**
     * 将字符串的首字母变为小写的
     * @param param  字符串
     * @return
     */
    public static String firstToLowerCase(String param) {
        char[] cs = param.toCharArray();
        if (cs[0] > 64 && cs[0] < 91) {
            cs[0] += 32;
        }
        return String.valueOf(cs);
    }

    /**
     * 将字符串的首字母变为大写的
     * @param param  字符串
     * @return
     */
    public static String firstToUpperCase(String param) {
        char[] cs = param.toCharArray();
        if (cs[0] > 96 && cs[0] < 123) {
            cs[0] -= 32;
        }
        return String.valueOf(cs);
    }

    /**
     * 把string array or list用给定的符号symbol连接成一个字符串
     *
     * @param source  需要处理的集合
     * @param symbol 链接的符号
     * @return 处理后的字符串
     */
    public static String join(Collection source, String symbol) {
        if(CollectionUtils.isEmpty(source)){
            return null;
        }
        StringBuilder sb = new StringBuilder();
        source.forEach(item->sb.append(item).append(symbol));
        String result = sb.toString();
        if (result.length() > 1 && StringUtils.isNotEmpty(symbol)) {
            result = result.substring(0, result.length() - symbol.length());
        }
        return result;
    }

    /**
     * 数字不足位数 补0
     * @param param  数字
     * @return
     */
    public static String cover(Long param,int len) {
        return String.format("%"+len+"d", param).replace(" ", "0");
    }

    /**
     * 数字不足位数 补0
     * @param param  数字
     * @return
     */
    public static String cover(Integer param,int len) {
        return String.format("%"+len+"d", param).replace(" ", "0");
    }

    /**
     * Clear xss script injection
     *
     * @param value script
     * @return not contains xss script
     */
    public static String cleanXSS(String value) {
        if (null == value) {
            return value;
        } else {
            value = value.replaceAll("\\bselect\\b", "invalid character");
            value = value.replaceAll("\\band\\b", "invalid character");
            value = value.replaceAll("\\bor\\b", "invalid character");
            value = value.replaceAll("\\bdelete\\b", "invalid character");
            value = value.replaceAll("\\bjoin\\b", "invalid character");
            value = value.replaceAll("\\bdrop\\b", "invalid character");

            value = value.replaceAll("\\+", "&#43;");
            value = value.replaceAll("&", "&amp;");
            value = value.replaceAll("%", "&#37;");
            // value = value.replaceAll("\"","&quot;");
            value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            value = value.replaceAll("%3C", "&lt;").replaceAll("%3E", "&gt;");
            value = value.replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;");
            value = value.replaceAll("%28", "&#40;").replaceAll("%29", "&#41;");
            value = value.replaceAll("'", "&#39;");
            value = value.replaceAll("alert", "invalid character");
            value = value.replaceAll("eval\\((.*)\\)", "invalid character");
            value = value.replaceAll("[\\\"\\\'][\\s]*javascript:(.*)[\\\"\\\']", "\"\"");
            value = value.replaceAll("<\\s*script", "invalid character");
            value = value.replaceAll("script", " ");
            value = value.replaceAll("location.href", "invalid character");
        }
        return value;
    }

    /**
     * InputStream转成String
     * @param is InputStream
     * @return String
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
            throw new RuntimeException("将流转换为字符串出错,错误的原因为:"+e.getMessage());
        } finally {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(is);
        }
        return sb.toString();
    }
}
