package top.doudou.base.util.file;

import lombok.extern.slf4j.Slf4j;
import top.doudou.base.exception.CustomException;
import top.doudou.base.exception.NotFoundFileException;
import top.doudou.base.stream.StreamCloseUtils;

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-12-30 14:26
 * @Version V1.0
 */
@Slf4j
public class FileReadAndWriteUtil {

    /**
     * 向文件中写入指定的内容
     * @param content  内容
     * @param file  文件
     */
    public static File writeObjToFile(String content, File file) throws IOException {
        if(file.isDirectory()){
            throw new CustomException(file.getName()+" is directory,not file");
        }
        FileUtil.touch(file);
//        if(file.isDirectory()){
//            file = new File(file.getPath()+File.separator+ RandomUtils.randomTimeStr());
//        }
        FileOutputStream outputStream = null;
        FileChannel fileChannel = null;
        try {
            outputStream = new FileOutputStream(file,true);
            fileChannel = outputStream.getChannel();
            byte[] bytes = content.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
            byteBuffer.put(bytes);
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
        }catch (FileNotFoundException e){
            throw new CustomException("file not found , filePath:{}",file.getPath());
        } catch (IOException e){
            throw new CustomException("write error , error message:{}",e.getMessage());
        }finally {
            StreamCloseUtils.close(outputStream);
            StreamCloseUtils.close(fileChannel);
        }
        return file;
    }


    /**
     * 读取文件的内容
     * @param file 文件路径
     * @throws FileNotFoundException
     * @return 返回以行为单位的数组数据
     */
    public static Object[] read(String file) throws FileNotFoundException {
        File file1 = new File(file);
        if(!file1.exists()){
            throw new NotFoundFileException("{} not exist",file);
        }
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            return reader.lines().toArray();
        }finally {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(fileReader);
        }
    }

    /**
     * 获取文件的总行数
     * @param file
     * @return
     * @throws IOException
     */
    public static int getTotalLines(File file) {
        FileReader in = null;
        LineNumberReader reader = null;
        try {
            in = new FileReader(file);
            reader = new LineNumberReader(in);
            String s = reader.readLine();
            int lines = 0;
            while (s != null) {
                lines++;
                s = reader.readLine();
            }
            return lines;
        }catch (IOException e){
            throw new CustomException(e);
        }finally {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(in);
        }
    }

    /**
     * 读取文件指定行
     * @param sourceFile
     * @param lineNumber
     * @throws IOException
     */
    public static String readAppointedLineNumber(File sourceFile, int lineNumber) {
        FileReader in = null;
        LineNumberReader reader = null;
        try {
            in = new FileReader(sourceFile);
            reader = new LineNumberReader(in);
            if (lineNumber < 0 || lineNumber > getTotalLines(sourceFile)) {
                throw new CustomException("不在文件的行数范围之内");
            }
            return reader.readLine();
        }catch (IOException e){
            throw new CustomException(e);
        }finally {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(in);
        }
    }
}

