package top.doudou.base.annotation;

import java.util.concurrent.TimeUnit;

/**
 * @Description 使用redis进行分布式锁
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-02-23 14:56
 * @Version V1.0
 */
public @interface RedisLock {
    /**
     * redis锁 名字
     */
    String lockName() default "";

    /**
     * redis锁 key 支持spel表达式
     */
    String key() default "";

    /**
     * 过期秒数,默认为5毫秒
     *
     * @return 轮询锁的时间
     */
    int expire() default 5000;

    /**
     * 超时时间单位
     *
     * @return 秒
     */
    TimeUnit timeUnit() default TimeUnit.MILLISECONDS;
}
