package top.doudou.base.exception;


import lombok.extern.slf4j.Slf4j;
import top.doudou.base.util.ChineseCharacterUtil;
import top.doudou.base.util.StrUtils;

/**
 * 自定义异常
 * @author 傻男人<244191347@qq.com>
 * @create 2020-09-18 14:56
 */
@Slf4j
public class CustomException extends RuntimeException {

    private static final long serialVersionUID = 8839929381238840384L;

    public CustomException(String message){
        super(message(message));
    }

    public CustomException(String message, Object... parameters){
        super(message(message,parameters));
    }

    public CustomException(Throwable cause) {
        super(cause);
    }

    public static String message(String message){
        if(!ChineseCharacterUtil.isContainChinese(message) && message.length() > 128){
            return "系统内部错误";
        }
        return message;
    }

    public static String message(String message,Object... parameters){
        return StrUtils.strReplace(message,parameters);
    }
}
