package top.doudou.base.exception;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-28 16:43
 * @Version V1.0
 */
public class ExceptionUtils {

    /**
     * 将Exception出错的栈信息转成字符串
     * @param e
     * @return
     */
    public static String toString(Exception e){

        try (StringWriter sw = new StringWriter(); PrintWriter writer = new PrintWriter(sw, true)) {
            e.printStackTrace(writer);
            writer.flush();
            sw.flush();
            return sw.toString();
        }catch (IOException ignored){
            throw new CustomException(ignored.getMessage(),ignored);
        }
    }

    /**
     * 将Throwable出错的栈信息转成字符串
     * @param e
     * @return
     */
    public static String toString(Throwable e) {
        try(StringWriter sw = new StringWriter();PrintWriter writer = new PrintWriter(sw, true)){
            e.printStackTrace(writer);
            writer.flush();
            sw.flush();
            return sw.toString();
        }catch (Exception ignored){
            throw new CustomException(ignored.getMessage(),ignored);
        }
    }
}
