package top.doudou.base.stream;

import lombok.extern.slf4j.Slf4j;
import top.doudou.base.exception.ExceptionUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.Channel;
import java.util.zip.ZipOutputStream;

/**
 * @Description 关闭流工具类
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-09-22 9:21
 * @Version V1.0
 */
@Slf4j
public class StreamCloseUtils {

    /**
     * 关闭输出流
     * @param outputStream
     */
    public static void close(OutputStream outputStream){
        if( null != outputStream){
            try {
                if(outputStream instanceof ZipOutputStream){
                    ((ZipOutputStream)outputStream).closeEntry();
                }
                outputStream.close();
            } catch (IOException e) {
                log.error("close outputStream error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    /**
     * 关闭输入流
     * @param inputStream
     */
    public static void close(InputStream inputStream){
        if( null != inputStream){
            try {
                inputStream.close();
            } catch (IOException e) {
                log.error("close inputStream error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    /**
     * 关闭输入流
     * @param channel
     */
    public static void close(Channel channel){
        if( null != channel){
            try {
                channel.close();
            } catch (IOException e) {
                log.error("close Channel error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    /**
     * 关闭reader
     * @param reader
     */
    public static void close(Reader reader){
        if( null != reader){
            try {
                reader.close();
            } catch (IOException e) {
                log.error("close Channel error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }


}
