package top.doudou.base.util;

import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import top.doudou.base.exception.CustomException;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2020/9/7 17:22
 * @Version: 1.0
 * @Description:
 */
@Slf4j
@Data
public class FieldUtils {

    /**
     * 获取private修饰的成员变量  获得某个类的所有声明的字段，即包括public、private和proteced也包括父类的申明字段。
     * @param target
     * @return
     */
    public static  List<Field> getAllFields(Class<?> target){
        List<Field> superField = getSuperField(target);
        Iterator<Field> iterator = superField.iterator();
        while (iterator.hasNext()){
            Field next = iterator.next();
            if ("serialVersionUID".equals(next.getName())) {
                iterator.remove();
            }
        }
        return superField;
    }

    /**
     * 获取所有非static、非Transient、非Final修饰的字段
     * @param target
     * @return
     */
    public static  List<Field> getAllNoStaticFinalTransientFields(Class<?> target){
        List<Field> superField = getSuperField(target);
        Iterator<Field> iterator = superField.iterator();
        while (iterator.hasNext()){
            Field next = iterator.next();
            if (Modifier.isStatic(next.getModifiers())
                    ||  Modifier.isFinal(next.getModifiers())
                        || Modifier.isTransient(next.getModifiers())) {
                iterator.remove();
            }
        }
        return superField;
    }

    private static List<Field> getSuperField(Class target){
        if(target.equals(Object.class)){
            return Lists.newArrayList();
        }
        List<Field> list = Lists.newArrayList();
        Field[] declaredFields = target.getDeclaredFields();
        list.addAll(Arrays.asList(declaredFields));
        Class<?> superclass = target.getSuperclass();
        list.addAll(getSuperField(superclass));
        return list;
    }

    /**
     * 通过field来获取当前field的属性值
     * @param field
     * @param obj
     * @return
     */
    public static Object getFieldValue(Field field,Object obj) {
        String methodSuffix = StrUtils.firstToUpperCase(field.getName());
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        try {
            Method method = getSpecificMethod(methods,methodSuffix);
            return method.invoke(obj);
        }catch (Exception e) {
            throw new CustomException("未获取到的值方法：get{}或者is{}",methodSuffix,methodSuffix);
        }
    }

    /**
     * 根据方法的后缀获取类的具体方法名
     * @param methods
     * @param methodSuffix
     * @return
     */
    private static Method getSpecificMethod(Method[] methods,String methodSuffix){
        for (int i = 0; i < methods.length; i++) {
            String name = methods[i].getName();
            if(name.startsWith("is") && name.equals(StrUtils.firstToLowerCase(methodSuffix))){
                return methods[i];
            }
            if(name.equals("is"+methodSuffix)){
                return methods[i];
            }
            if(name.equals("get"+methodSuffix)){
                return methods[i];
            }
        }
        throw new CustomException("方法未找到：get{}或者is{}",methodSuffix,methodSuffix);
    }

    /**
     * 通过fieldName来获取属性的值
     * @param fieldName
     * @param obj
     * @return
     * @throws NoSuchFieldException
     */
    public static Object getFieldValue(String fieldName,Object obj) throws NoSuchFieldException {
        return getFieldValue(obj.getClass().getField(fieldName),obj);
    }

    /**
     * 获取属性的值，如果错误则返回null
     * @param field
     * @param obj
     * @return
     */
    public static Object getFieldValueNoException(Field field,Object obj) {
        try{
            return getFieldValue(field,obj);
        }catch (Exception e){
            log.error(e.getMessage());
            return null;
        }
    }

}
