package top.doudou.base.util;

import java.io.Serializable;

/**
 * @Description 提示语
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-02-22 11:27
 * @Version V1.0
 */
public class SuggestiveLanguage implements Serializable {

    public final static String PRIMARY_NOT_NULL = "主键id不能为空";

    public final static String NAME_REPEAT = "名字已经被使用";

    public final static String NOT_REPEAT = "不能重复";

    public final static String NON_EXISTENT = "不存在";

    public final static String NOT_EMPTY = "不能为空";

    public final static String PARAMETER_ERROR = "参数错误";

    public final static String CLIENT_CALL_RETURN_NULL = "远程调用返回数据为null";

    /**
     * 名字重复
     * @param name
     * @return
     */
    public static String nameRepeat(String name){ return name + NAME_REPEAT; }

    /**
     * 名字不能重复
     * @param name
     * @return
     */
    public static String notRepeat(String name){ return name + NAME_REPEAT; }

    /**
     * 参数不存在
     * @param parameter
     * @return
     */
    public static String nonExistent(String parameter){
        return parameter + NON_EXISTENT;
    }

    /**
     * 参数不能为空
     * @param parameter
     * @return
     */
    public static String notEmpty(String parameter){
        return parameter + NOT_EMPTY;
    }

    /**
     * 参数错误
     * @param parameter
     * @return
     */
    public static String parameterError(String parameter){
        return parameter + PARAMETER_ERROR;
    }

    /**
     * 远程调用异常结果
     * @param parameter
     * @return
     */
    public static String clientCall(String parameter){
        return "远程调用失败，失败得信息为:"+parameter;
    }

}
