package top.doudou.base.web;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import top.doudou.base.builder.JsonBuilder;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-02-08 11:36
 * @Version V1.0
 */
public class ResponseUtil {

    public static void write(HttpServletResponse response,Object result){
        write(response,HttpStatus.OK,result);
    }

    public static void write(HttpServletResponse response, HttpStatus status,Object result){
        if(null == response){
            return;
        }
        if(null == status){
            status = HttpStatus.OK;
        }
        if(null == result){
            result = "";
        }
        try{
            response.setStatus(status.value());
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_VALUE);
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonBuilder.gson().toJson(result));
            response.getWriter().flush();
        }catch (IOException e) {
            e.printStackTrace();
        }
    }
}
