/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BaseBuilder<T> {
    private final Supplier<T> instantiator;
    private List<Consumer<T>> modifiers = new ArrayList<Consumer<T>>();

    public BaseBuilder(Supplier<T> instantiator) {
        this.instantiator = instantiator;
    }

    public static <T> BaseBuilder<T> of(Supplier<T> instantiator) {
        return new BaseBuilder<T>(instantiator);
    }

    public <P1> BaseBuilder<T> with(Consumer1<T, P1> consumer, P1 p1) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2> BaseBuilder<T> with(Consumer2<T, P1, P2> consumer, P1 p1, P2 p2) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2);
        this.modifiers.add(c);
        return this;
    }

    public <P1, P2, P3> BaseBuilder<T> with(Consumer3<T, P1, P2, P3> consumer, P1 p1, P2 p2, P3 p3) {
        Consumer<Object> c = instance -> consumer.accept(instance, p1, p2, p3);
        this.modifiers.add(c);
        return this;
    }

    public T build() {
        Object value = this.instantiator.get();
        this.modifiers.forEach(modifier -> modifier.accept(value));
        this.modifiers.clear();
        return value;
    }

    @FunctionalInterface
    public static interface Consumer3<T, P1, P2, P3> {
        public void accept(T var1, P1 var2, P2 var3, P3 var4);
    }

    @FunctionalInterface
    public static interface Consumer2<T, P1, P2> {
        public void accept(T var1, P1 var2, P2 var3);
    }

    @FunctionalInterface
    public static interface Consumer1<T, P1> {
        public void accept(T var1, P1 var2);
    }
}

