/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.convert;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import top.doudou.base.builder.JsonBuilder;
import top.doudou.base.exception.ConvertException;
import top.doudou.base.exception.CustomException;
import top.doudou.base.exception.ExceptionUtils;
import top.doudou.base.stream.StreamCloseUtils;
import top.doudou.base.util.FieldUtils;

public class ConvertBeanUtils {
    private static final Logger log = LoggerFactory.getLogger(ConvertBeanUtils.class);

    public static <T, E> T copyProperties(E entity, Class<T> doClass) {
        if (entity == null) {
            return null;
        }
        if (doClass == null) {
            log.info("\u8f6c\u6362\u7684class\u4e0d\u80fd\u4e3anull");
            throw new CustomException("\u8f6c\u6362\u7684class\u4e0d\u80fd\u4e3anull");
        }
        try {
            T newInstance = doClass.newInstance();
            BeanUtils.copyProperties(entity, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            log.error("\u5c5e\u6027\u8f6c\u6362\u5f02\u5e38\uff01\uff0c\u51fa\u9519\u7684bean\u5c5e\u6027\u4e3a\uff1a{}", entity);
            throw new CustomException("bean\u5c5e\u6027\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static void copyProperties(Object source, Object target) {
        if (source == null || target == null) {
            throw new CustomException("\u6e90\u6216\u8005\u76ee\u6807\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BeanUtils.copyProperties((Object)source, (Object)target);
        }
        catch (Exception e) {
            log.error("\u5c5e\u6027\u8f6c\u6362\u5f02\u5e38\uff01\uff0c\u51fa\u9519\u7684source\u5c5e\u6027\u4e3a\uff1a{}", source);
            throw new CustomException("bean\u5c5e\u6027\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Map<String, Object> convertBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        try {
            List<Field> fields = FieldUtils.getAllNoStaticFinalTransientFields(obj.getClass());
            for (Field field : fields) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj));
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtils.toString(e));
        }
        return map;
    }

    public static Map<String, String> convertMap(Map<String, Object> map) {
        HashMap result = Maps.newHashMap();
        map.forEach((key, value) -> result.put(key, new Gson().toJson(value)));
        return result;
    }

    public static Map<String, Object> convert2Map(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return Maps.newHashMap();
        }
        return (Map)JsonBuilder.gson().fromJson(json, Map.class);
    }

    public static <T> T convert(String json, Class<T> target, Charset charset) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        Object t = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            t = mapper.readValue(new String(json.getBytes(charset), charset), target);
            return (T)t;
        }
        catch (IOException e) {
            log.error(ExceptionUtils.toString(e));
            return (T)t;
        }
    }

    public static Map<String, Object> objToMap(Object obj) {
        Gson gson = new Gson();
        return (Map)gson.fromJson(gson.toJson(obj), Map.class);
    }

    public static Map<String, Object> convertBeanToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap map = Maps.newHashMap();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("serialVersionUID") || key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                if (null == value) {
                    map.put(key, "");
                    continue;
                }
                map.put(key, value);
            }
        }
        catch (Exception e) {
            log.error("convertBean2Map Error {}", (Throwable)e);
        }
        return map;
    }

    public static <T> T mapToObj(Map<String, Object> map, Class<T> beanClass) {
        Gson gson = JsonBuilder.gson();
        String toJson = gson.toJson(map);
        return (T)gson.fromJson(toJson, beanClass);
    }

    public static <T> List<T> linkedMapTypeListToObjectList(Object source, Class<T> target) {
        if (null == source || "".equals(source.toString().trim()) || "[]".equals(source.toString())) {
            return Lists.newArrayList();
        }
        return JSONObject.parseArray((String)JSONObject.toJSONString((Object)source)).toJavaList(target);
    }

    public static <T> T copyPropertiesContainList(Object source, Class<T> doClass) {
        if (source == null) {
            return null;
        }
        if (doClass == null) {
            log.info("\u8f6c\u6362\u7684class\u4e0d\u80fd\u4e3anull");
            throw new CustomException("\u8f6c\u6362\u7684class\u4e0d\u80fd\u4e3anull");
        }
        Field[] sourFields = source.getClass().getDeclaredFields();
        HashMap sourFieldMap = Maps.newHashMap();
        Arrays.stream(sourFields).forEach(sourField -> sourFieldMap.put(sourField.getName(), sourField));
        try {
            Field[] tarFields;
            T target = doClass.newInstance();
            for (Field tarField : tarFields = target.getClass().getDeclaredFields()) {
                Iterable sourList;
                Field sourField2 = (Field)sourFieldMap.get(tarField.getName());
                if (sourField2 == null || "serialVersionUID".equals(sourField2.getName())) continue;
                Class tarGenericClass = ConvertBeanUtils.getGenericClass(tarField);
                Class sourGenericClass = ConvertBeanUtils.getGenericClass(sourField2);
                Class<?> sourType = sourField2.getType();
                Class<?> tarType = tarField.getType();
                sourField2.setAccessible(true);
                tarField.setAccessible(true);
                if (tarGenericClass == null && sourGenericClass == null) {
                    if (!sourType.isAssignableFrom(tarType)) continue;
                    tarField.set(target, sourField2.get(source));
                    continue;
                }
                if (tarGenericClass == null || sourGenericClass == null || (sourList = (Iterable)sourField2.get(source)) == null) continue;
                ArrayList tarList = Lists.newArrayList();
                for (Object sourObj : sourList) {
                    tarList.add(ConvertBeanUtils.copyPropertiesContainList(sourObj, tarGenericClass.newInstance().getClass()));
                }
                tarField.set(target, tarList);
            }
            return target;
        }
        catch (Exception e) {
            log.info("\u590d\u5236\u5c5e\u6027\u51fa\u9519");
            throw new CustomException("bean\u5c5e\u6027\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private static Class getGenericClass(Field field) throws Exception {
        Class<List> type = field.getType();
        if (type.isAssignableFrom(List.class)) {
            Type genericType = field.getGenericType();
            if (genericType == null) {
                return null;
            }
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                Type[] genericArgs = pt.getActualTypeArguments();
                if (genericArgs.length > 1) {
                    throw new Exception(genericType + "  " + field.getName() + ": \u6cdb\u578b\u4e0d\u53ea\u4e00\u4e2a\u65e0\u6cd5\u8d4b\u503c");
                }
                return (Class)genericArgs[0];
            }
        }
        return null;
    }

    public static byte[] objectToByte(Object obj) {
        byte[] byArray;
        ByteArrayOutputStream bo = null;
        ObjectOutputStream oo = null;
        try {
            byte[] bytes;
            bo = new ByteArrayOutputStream();
            oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            byArray = bytes = bo.toByteArray();
        }
        catch (Exception e) {
            try {
                log.info(" \u5bf9\u8c61\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
                throw new ConvertException("convert to byte[] error");
            }
            catch (Throwable throwable) {
                StreamCloseUtils.close(bo);
                StreamCloseUtils.close(oo);
                throw throwable;
            }
        }
        StreamCloseUtils.close(bo);
        StreamCloseUtils.close(oo);
        return byArray;
    }

    public static Object byteToObject(byte[] bytes) {
        Object object;
        ByteArrayInputStream bi = null;
        ObjectInputStream oi = null;
        try {
            bi = new ByteArrayInputStream(bytes);
            oi = new ObjectInputStream(bi);
            object = oi.readObject();
        }
        catch (Exception e) {
            try {
                log.info("\u5bf9\u8c61\u53cd\u5e8f\u5217\u5316\u51fa\u73b0\u95ee\u9898\uff0c\u51fa\u73b0\u95ee\u9898\u7684\u539f\u56e0\u4e3a {}", (Object)e.getMessage());
                throw new ConvertException("byte[] convert to Object error");
            }
            catch (Throwable throwable) {
                StreamCloseUtils.close(bi);
                StreamCloseUtils.close(oi);
                throw throwable;
            }
        }
        StreamCloseUtils.close(bi);
        StreamCloseUtils.close(oi);
        return object;
    }

    public static <T> T byteToObject(Class<T> target, byte[] bytes) {
        return (T)ConvertBeanUtils.byteToObject(bytes);
    }

    public static void setProperty(Object bean, String fieldName, Object value) {
        try {
            Field field = ConvertBeanUtils.getFieldAndAccessible(bean, fieldName);
            field.set(bean, value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T getProperty(Object bean, String fieldName, Class<T> target) {
        try {
            Field field = ConvertBeanUtils.getFieldAndAccessible(bean, fieldName);
            return (T)field.get(bean);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.toString(e));
            throw new CustomException(e);
        }
    }

    public static Field getFieldAndAccessible(Object bean, String fieldName) {
        try {
            Class<?> aClass = bean.getClass();
            Field field = aClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new CustomException(e);
        }
    }
}

