/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.random;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import top.doudou.base.exception.CustomException;

public class RandomUtils {
    public static final String NUM_LETTER_CODE = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LETTER_CODE = "abcdefghijkllmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String NUM_CODE = "0123456789";

    public static String randomTime() {
        return new SimpleDateFormat("yyMMddHHmmss").format(new Date());
    }

    public static String randomTimeStr() {
        return new SimpleDateFormat("yyMMddHHmmssSSS").format(new Date()) + RandomUtils.number(3);
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String randomUUID(int len) {
        if (len < 0 || len > 32) {
            throw new CustomException("the len ranges from 1 to 32");
        }
        if (len == 0) {
            return "";
        }
        return RandomUtils.randomUUID().substring(0, len);
    }

    public static int randomInt(int scopeMin, int scopeMax) {
        Random random = new Random();
        return random.nextInt(scopeMax) % (scopeMax - scopeMin + 1) + scopeMin;
    }

    public static String number(int len) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            sb.append(NUM_CODE.charAt(random.nextInt(NUM_CODE.length())));
        }
        return sb.toString();
    }

    public static String random(int len) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            sb.append(NUM_LETTER_CODE.charAt(random.nextInt(NUM_LETTER_CODE.length())));
        }
        return sb.toString();
    }

    public static String randomStr(int len) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < len; ++i) {
            sb.append(LETTER_CODE.charAt(random.nextInt(LETTER_CODE.length())));
        }
        return sb.toString();
    }

    public static String randomLowerStr(int length) {
        return RandomUtils.randomStr(length).toLowerCase();
    }

    public static String randomUpperStr(int length) {
        return RandomUtils.randomStr(length).toUpperCase();
    }

    public static String zeroString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append('0');
        }
        return sb.toString();
    }
}

