/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.respond;

import com.google.gson.Gson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="Result<T>", description="\u901a\u7528\u54cd\u5e94")
public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 2261554643166465633L;
    @ApiModelProperty(value="\u7f16\u7801\uff1a0\u8868\u793a\u6210\u529f\uff0c\u5176\u4ed6\u503c\u8868\u793a\u5931\u8d25")
    private int code;
    @ApiModelProperty(value="\u8bf7\u6c42\u5e8f\u5217\u53f7")
    private String requestCode;
    @ApiModelProperty(value="\u6d88\u606f\u5185\u5bb9")
    private String message;
    @ApiModelProperty(value="\u54cd\u5e94\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u5f02\u5e38\u7684\u4fe1\u606f")
    private String errorMsg;
    @ApiModelProperty(value="\u65f6\u95f4\u6233")
    private Long timestamp = System.currentTimeMillis();

    public static <E> Result<E> ok() {
        return new Result().success();
    }

    public static <E> Result ok(E data) {
        return new Result<E>().success(data);
    }

    public Result success() {
        this.code = 0;
        this.setMessage("success");
        return this;
    }

    public Result success(T data) {
        this.success();
        this.setData(data);
        return this;
    }

    public static <E> Result<E> fail() {
        return new Result().error();
    }

    public static <E> Result fail(String message) {
        return new Result().error(message);
    }

    public static <T> Result fail(String message, T data) {
        Result<T> result = new Result<T>();
        result.setMessage(message);
        result.setData(data);
        result.code = 1000;
        return result;
    }

    public Result error() {
        this.code = 1000;
        this.message = "error";
        return this;
    }

    public Result<T> error(int code) {
        this.code = code;
        this.message = "error";
        return this;
    }

    public static Result error(int code, String msg) {
        Result result = new Result();
        result.setCode(code);
        result.setMessage(msg);
        return result;
    }

    public static <T extends Exception> Result error(int code, String message, T e) {
        Result<T> result = new Result<T>();
        result.setMessage(message);
        result.setErrorMsg(e.getMessage());
        result.setCode(code);
        return result;
    }

    public static Result error(int code, String message, Object obj) {
        Result result = new Result();
        result.code = code;
        result.message = message;
        result.errorMsg = new Gson().toJson(obj);
        return result;
    }

    public static Result error(String message, String errorMsg) {
        Result result = new Result();
        result.setMessage(message);
        result.setErrorMsg(errorMsg);
        result.setCode(1000);
        return result;
    }

    public Result<T> error(String msg) {
        this.message = msg;
        this.code = 1000;
        return this;
    }

    public int getCode() {
        return this.code;
    }

    public String getRequestCode() {
        return this.requestCode;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setRequestCode(String requestCode) {
        this.requestCode = requestCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$requestCode = this.getRequestCode();
        String other$requestCode = other.getRequestCode();
        if (this$requestCode == null ? other$requestCode != null : !this$requestCode.equals(other$requestCode)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $requestCode = this.getRequestCode();
        result = result * 59 + ($requestCode == null ? 43 : $requestCode.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "Result(code=" + this.getCode() + ", requestCode=" + this.getRequestCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", errorMsg=" + this.getErrorMsg() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

