/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channel;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.ExceptionUtils;

public class StreamCloseUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamCloseUtils.class);

    public static void close(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                if (outputStream instanceof ZipOutputStream) {
                    ((ZipOutputStream)outputStream).closeEntry();
                }
                outputStream.close();
            }
            catch (IOException e) {
                log.error("close outputStream error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    public static void close(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("close inputStream error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    public static void close(Channel channel) {
        if (null != channel) {
            try {
                channel.close();
            }
            catch (IOException e) {
                log.error("close Channel error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    public static void close(Reader reader) {
        if (null != reader) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error("close Channel error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }

    public static void close(Writer writer) {
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException e) {
                log.error("close writer error");
                log.error(ExceptionUtils.toString(e));
            }
        }
    }
}

