/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.ExceptionUtils;
import top.doudou.base.util.StrUtils;

public class ChineseCharacterUtil {
    private static final Logger log = LoggerFactory.getLogger(ChineseCharacterUtil.class);

    public static String getUpperCase(String chinese) {
        return ChineseCharacterUtil.convertChinese2Pinyin(chinese, true).toUpperCase();
    }

    public static String getLowerCase(String chinese) {
        return ChineseCharacterUtil.convertChinese2Pinyin(chinese, true).toLowerCase();
    }

    public static String getInitials(String chinese) {
        return ChineseCharacterUtil.convertChinese2Pinyin(chinese, false);
    }

    public static String getChineseFirstUpper(String chinese) {
        return ChineseCharacterUtil.convertChinese2Pinyin(chinese, null);
    }

    private static String convertChinese2Pinyin(String chinese, Boolean isFull) {
        String regExp = "^[\u4e00-\u9fff]+$";
        StringBuffer sb = new StringBuffer();
        if (chinese == null || "".equals(chinese.trim())) {
            return "";
        }
        String pinyin = "";
        for (int i = 0; i < chinese.length(); ++i) {
            char unit = chinese.charAt(i);
            if (ChineseCharacterUtil.match(String.valueOf(unit), regExp)) {
                pinyin = ChineseCharacterUtil.convertSingleHanzi2Pinyin(unit);
                if (null == isFull) {
                    sb.append(StrUtils.firstToUpperCase(pinyin));
                    continue;
                }
                if (isFull.booleanValue()) {
                    sb.append(pinyin);
                    continue;
                }
                sb.append(pinyin.charAt(0));
                continue;
            }
            sb.append(unit);
        }
        return sb.toString();
    }

    private static String convertSingleHanzi2Pinyin(char hanzi) {
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        StringBuffer sb = new StringBuffer();
        try {
            String[] res = PinyinHelper.toHanyuPinyinStringArray((char)hanzi, (HanyuPinyinOutputFormat)outputFormat);
            sb.append(res[0]);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.toString(e));
            return "";
        }
        return sb.toString();
    }

    private static boolean match(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isContainChinese(String str) {
        String regex = "[\u4e00-\u9fa5]";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(str);
        return match.find();
    }
}

