/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util;

import java.util.Collection;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import top.doudou.base.exception.ValidateException;

public class FastAssert {
    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new ValidateException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        FastAssert.state(expression, message);
    }

    public static void isNull(@Nullable Object object, String message) {
        if (object != null) {
            throw new ValidateException(message);
        }
    }

    public static void notNull(@Nullable Object obj, String message) {
        if (null == obj) {
            throw new ValidateException(message);
        }
    }

    public static void notEmpty(@Nullable Object obj, String message) {
        FastAssert.notNull(obj, message);
        if (obj instanceof String && StringUtils.isEmpty((Object)obj)) {
            throw new ValidateException(message);
        }
        if (obj instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)obj))) {
            throw new ValidateException(message);
        }
        if (obj instanceof Map && CollectionUtils.isEmpty((Map)((Map)obj))) {
            throw new ValidateException(message);
        }
    }

    public static void hasLength(@Nullable String text, String message) {
        if (!StringUtils.hasLength((String)text)) {
            throw new ValidateException(message);
        }
    }

    public static void hasText(@Nullable String text, String message) {
        if (!StringUtils.hasText((String)text)) {
            throw new ValidateException(message);
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, String message) {
        if (StringUtils.hasLength((String)textToSearch) && StringUtils.hasLength((String)substring) && textToSearch.contains(substring)) {
            throw new ValidateException(message);
        }
    }

    public static void noNullElements(@Nullable Object[] array, String message) {
        if (array != null) {
            Object[] var2 = array;
            int var3 = array.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                Object element = var2[var4];
                if (element != null) continue;
                throw new ValidateException(message);
            }
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, String message) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new ValidateException(message);
            }
        }
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj, String message) {
        FastAssert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            FastAssert.instanceCheckFailed(type, obj, message);
        }
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj) {
        FastAssert.isInstanceOf(type, obj, "");
    }

    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, String message) {
        FastAssert.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            FastAssert.assignableCheckFailed(superType, subType, message);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        FastAssert.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, @Nullable Object obj, @Nullable String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        String result = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength((String)msg)) {
            if (FastAssert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = FastAssert.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw new IllegalArgumentException(result);
    }

    private static void assignableCheckFailed(Class<?> superType, @Nullable Class<?> subType, @Nullable String msg) {
        String result = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength((String)msg)) {
            if (FastAssert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = FastAssert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException(result);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, @Nullable Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }
}

