/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.CustomException;
import top.doudou.base.util.StrUtils;

public class FieldUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldUtils.class);

    public static List<Field> getAllFields(Class<?> target) {
        List<Field> superField = FieldUtils.getSuperField(target);
        Iterator<Field> iterator = superField.iterator();
        while (iterator.hasNext()) {
            Field next = iterator.next();
            if (!"serialVersionUID".equals(next.getName())) continue;
            iterator.remove();
        }
        return superField;
    }

    public static List<Field> getAllNoStaticFinalTransientFields(Class<?> target) {
        if (null == target) {
            log.error(" target \u7684\u503c\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List<Field> superField = FieldUtils.getSuperField(target);
        Iterator<Field> iterator = superField.iterator();
        while (iterator.hasNext()) {
            Field next = iterator.next();
            if (!Modifier.isStatic(next.getModifiers()) && !Modifier.isFinal(next.getModifiers()) && !Modifier.isTransient(next.getModifiers())) continue;
            iterator.remove();
        }
        return superField;
    }

    private static List<Field> getSuperField(Class target) {
        if (target.equals(Object.class)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        Field[] declaredFields = target.getDeclaredFields();
        list.addAll(Arrays.asList(declaredFields));
        Class superclass = target.getSuperclass();
        list.addAll(FieldUtils.getSuperField(superclass));
        return list;
    }

    public static Object getFieldValue(Field field, Object obj) {
        String methodSuffix = StrUtils.firstToUpperCase(field.getName());
        Class<?> clazz = obj.getClass();
        Method[] methods = clazz.getMethods();
        try {
            Method method = FieldUtils.getSpecificMethod(methods, methodSuffix);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new CustomException("\u672a\u83b7\u53d6\u5230\u7684\u503c\u65b9\u6cd5\uff1aget{}\u6216\u8005is{}", methodSuffix, methodSuffix);
        }
    }

    private static Method getSpecificMethod(Method[] methods, String methodSuffix) {
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (name.startsWith("is") && name.equals(StrUtils.firstToLowerCase(methodSuffix))) {
                return methods[i];
            }
            if (name.equals("is" + methodSuffix)) {
                return methods[i];
            }
            if (!name.equals("get" + methodSuffix)) continue;
            return methods[i];
        }
        throw new CustomException("\u65b9\u6cd5\u672a\u627e\u5230\uff1aget{}\u6216\u8005is{}", methodSuffix, methodSuffix);
    }

    public static Object getFieldValue(String fieldName, Object obj) throws NoSuchFieldException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        return FieldUtils.getFieldValue(field, obj);
    }

    public static Object getFieldValueNoException(Field field, Object obj) {
        try {
            return FieldUtils.getFieldValue(field, obj);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldUtils)) {
            return false;
        }
        FieldUtils other = (FieldUtils)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldUtils;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "FieldUtils()";
    }
}

