/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class LogUtil {
    private static final String TIME_FORMAT = "[\\d+][\\d+][\\d+][\\d+]-[\\d+][\\d+]-[\\d+][\\d+] [\\d+][\\d+]:[\\d+][\\d+]:[\\d+][\\d+]";
    private static final String DEBUG = "<span style='color: blue;'>";
    private static final String INFO = "<span style='color: green;'>";
    private static final String WARN = "<span style='color: orange;'>";
    private static final String ERROR = "<span style='color: red;'>";
    private static final String BLACK = "<span style='color: black;'>";
    private static final String SPACE = "&nbsp;";
    private static final String SHORT_SPACE = "&nbsp;&nbsp;&nbsp;";
    private static final String LONG_SPACE = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String SPAN_OVER = "</span>";
    private static final int FIRST_MAX = 400;
    private static final String STDOUT_CONSOLE = "StdoutListener$$EnhancerBySpringCGLIB$$";
    private static final String STDOUT_CONSOLE_SPLIT = "StdoutListener\\$\\$EnhancerBySpringCGLIB\\$\\$";
    private static final String REG_EXP = "\\w+\\s*\\[\\d+\\]\\s*-\\s*";
    private static final String SPLIT = "  ";

    public static String toColor(String line) {
        if (line.contains(STDOUT_CONSOLE)) {
            String result = line.split(STDOUT_CONSOLE_SPLIT)[1].replaceFirst(REG_EXP, "");
            return "<br/>" + result;
        }
        line = line.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
        line = line.replace("DEBUG", "<span style='color: blue;'>DEBUG</span>");
        line = line.replace("INFO", "<span style='color: green;'>INFO</span>");
        line = line.replace("WARN", "<span style='color: orange;'>WARN</span>");
        line = line.replace("ERROR", "<span style='color: red;'>ERROR</span>");
        StringBuffer sb = new StringBuffer("<br/>");
        String[] split = line.split(SPLIT);
        if (split.length >= 5) {
            sb.append(split[0]).append(SHORT_SPACE).append(split[1]).append(SHORT_SPACE).append(split[2]).append(SHORT_SPACE).append(BLACK).append(split[3]).append(SPAN_OVER).append(SHORT_SPACE);
            String[] temp = split[4].split("-");
            if (temp.length > 1) {
                sb.append(temp[0]).append(LogUtil.messageColor(sb.toString(), temp, 1));
            } else {
                sb.append(split[4]);
            }
            if (split.length > 5) {
                sb.append(LogUtil.messageColor(sb.toString(), split, 5));
            }
        }
        if (sb.length() <= 5) {
            if (line.startsWith("\tat ")) {
                sb.append(ERROR).append(LONG_SPACE).append(line).append(SPAN_OVER);
            } else {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(LogUtil.toColor("2020-10-23 10:37:19  [INFO ]  [Thread-34]  top.doudou.base.config.StdoutListener$$EnhancerBySpringCGLIB$$633c4e2e  [24] - 2020-10-23 10:37:19"));
    }

    private static String messageColor(String line, String[] temp, int startLen) {
        if (temp.length <= 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = startLen; i < temp.length; ++i) {
            sb.append(SPLIT + temp[i]);
        }
        StringBuilder message = new StringBuilder();
        message.append(SHORT_SPACE);
        if (line.contains(DEBUG)) {
            message.append(DEBUG);
        } else if (line.contains(INFO)) {
            message.append(INFO);
        } else if (line.contains(WARN)) {
            message.append(WARN);
        } else if (line.contains(ERROR)) {
            message.append(ERROR);
        }
        message.append((CharSequence)sb);
        message.append(SPAN_OVER);
        return message.toString();
    }

    public static String handler(Object[] lines, boolean first) {
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = LogUtil.toColor((String)lines[i]);
        }
        if (first && lines.length > 400) {
            lines = Arrays.copyOfRange(lines, lines.length - 400, lines.length);
            first = false;
        }
        return StringUtils.join((Object[])lines, (String)"");
    }
}

