/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.util.WebUtils;
import top.doudou.base.util.ClassUtils;

public class ServletUtils {
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);

    public static HttpServletRequest getRequest() {
        return ServletUtils.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtils.getRequestAttributes().getResponse();
    }

    private static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public boolean isBody(HandlerMethod handlerMethod) {
        ResponseBody responseBody = ClassUtils.getAnnotation(handlerMethod, ResponseBody.class);
        return responseBody != null;
    }

    public String getCookieVal(String name) {
        HttpServletRequest request = ServletUtils.getRequest();
        Assert.notNull((Object)request, (String)"request from RequestContextHolder is null");
        return this.getCookieVal(request, name);
    }

    public String getCookieVal(HttpServletRequest request, String name) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)name);
        return cookie != null ? cookie.getValue() : null;
    }

    public void removeCookie(HttpServletResponse response, String key) {
        this.setCookie(response, key, null, 0);
    }

    public void setCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        cookie.setMaxAge(maxAgeInSeconds);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    public void renderJson(HttpServletResponse response, Object result) {
        this.renderJson(response, result, "application/json");
    }

    public void renderJson(HttpServletResponse response, Object result, String contentType) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(contentType);
        try (PrintWriter out = response.getWriter();){
            out.append(new Gson().toJson(result));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, String> getHeaders(HttpServletRequest request, boolean getContentLength) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration enums = request.getHeaderNames();
        while (enums.hasMoreElements()) {
            try {
                String key = (String)enums.nextElement();
                String value = request.getHeader(key);
                if (key.equals("content-length") && !getContentLength) continue;
                map.put(key, value);
            }
            catch (Exception exception) {}
        }
        return map;
    }
}

