/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import top.doudou.base.stream.StreamCloseUtils;

public class StrUtils {
    private static final String REPLACE_STR = "\\{\\}";

    public static String strReplace(String format, Object ... arguments) {
        return StrUtils.replaceAppointStr(format, REPLACE_STR, arguments);
    }

    public static String replaceAppointStr(String format, String replace, Object ... arguments) {
        if (StringUtils.isBlank((CharSequence)format)) {
            return format;
        }
        Matcher m = Pattern.compile(replace).matcher(format);
        int i = 0;
        while (m.find() && i < arguments.length) {
            format = format.replaceFirst(replace, String.valueOf(arguments[i++]));
        }
        return format;
    }

    public static String firstToLowerCase(String param) {
        char[] cs = param.toCharArray();
        if (cs[0] > '@' && cs[0] < '[') {
            cs[0] = (char)(cs[0] + 32);
        }
        return String.valueOf(cs);
    }

    public static String firstToUpperCase(String param) {
        char[] cs = param.toCharArray();
        if (cs[0] > '`' && cs[0] < '{') {
            cs[0] = (char)(cs[0] - 32);
        }
        return String.valueOf(cs);
    }

    public static String join(Collection source, String symbol) {
        if (CollectionUtils.isEmpty((Collection)source)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        source.forEach(item -> sb.append(item).append(symbol));
        String result = sb.toString();
        if (result.length() > 1 && StringUtils.isNotEmpty((CharSequence)symbol)) {
            result = result.substring(0, result.length() - symbol.length());
        }
        return result;
    }

    public static String cover(Long param, int len) {
        return String.format("%" + len + "d", param).replace(" ", "0");
    }

    public static String cover(Integer param, int len) {
        return String.format("%" + len + "d", param).replace(" ", "0");
    }

    public static String padPre(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String cleanXSS(String value) {
        if (null == value) {
            return value;
        }
        value = value.replaceAll("\\bselect\\b", "invalid character");
        value = value.replaceAll("\\band\\b", "invalid character");
        value = value.replaceAll("\\bor\\b", "invalid character");
        value = value.replaceAll("\\bdelete\\b", "invalid character");
        value = value.replaceAll("\\bjoin\\b", "invalid character");
        value = value.replaceAll("\\bdrop\\b", "invalid character");
        value = value.replaceAll("\\+", "&#43;");
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("%", "&#37;");
        value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("%3C", "&lt;").replaceAll("%3E", "&gt;");
        value = value.replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;");
        value = value.replaceAll("%28", "&#40;").replaceAll("%29", "&#41;");
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("alert", "invalid character");
        value = value.replaceAll("eval\\((.*)\\)", "invalid character");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("<\\s*script", "invalid character");
        value = value.replaceAll("script", " ");
        value = value.replaceAll("location.href", "invalid character");
        return value;
    }

    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5c06\u6d41\u8f6c\u6362\u4e3a\u5b57\u7b26\u4e32\u51fa\u9519,\u9519\u8bef\u7684\u539f\u56e0\u4e3a:" + e.getMessage());
        }
        finally {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(is);
        }
        return sb.toString();
    }
}

