/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import top.doudou.base.exception.CustomException;
import top.doudou.base.exception.NotFoundFileException;
import top.doudou.base.stream.StreamCloseUtils;
import top.doudou.base.util.file.FileUtil;

public class FileReadAndWriteUtil {
    private static final Logger log = LoggerFactory.getLogger(FileReadAndWriteUtil.class);
    private static TaskExecutor FILE_WRITE_POOL = FileReadAndWriteUtil.init();

    private static TaskExecutor init() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(9);
        executor.setMaxPoolSize(36);
        executor.setQueueCapacity(256);
        executor.setKeepAliveSeconds(0);
        executor.setThreadNamePrefix("async-file-write-pool-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        executor.initialize();
        return executor;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File writeObjToFile(String content, File file) throws IOException {
        if (file.isDirectory()) {
            throw new CustomException(file.getName() + " is directory,not file");
        }
        FileUtil.createNewFile(file);
        FileOutputStream outputStream = null;
        FileChannel fileChannel = null;
        try {
            outputStream = new FileOutputStream(file, true);
            fileChannel = outputStream.getChannel();
            byte[] bytes = content.getBytes();
            ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
            byteBuffer.put(bytes);
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CustomException("file not found , filePath:{}", file.getPath());
                catch (IOException e2) {
                    throw new CustomException("write error , error message:{}", e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                StreamCloseUtils.close(outputStream);
                StreamCloseUtils.close(fileChannel);
                throw throwable;
            }
        }
        StreamCloseUtils.close(outputStream);
        StreamCloseUtils.close(fileChannel);
        return file;
    }

    public static void asyncLogToFile(String file, String log) {
        FILE_WRITE_POOL.execute(() -> {
            try {
                FileReadAndWriteUtil.writeObjToFile(log, new File(file));
            }
            catch (IOException e) {
                System.out.println("\u5411\u6587\u4ef6\uff1a" + file + "\u4e2d\u5199\u5165\u65e5\u5fd7\uff1a{}" + log + "\u9519\u8bef,\u9519\u8bef\u7684\u4fe1\u606f\u4e3a:" + e.getMessage());
            }
        });
    }

    public static void asyncLogToFile(File file, String log) {
        FILE_WRITE_POOL.execute(() -> {
            try {
                FileReadAndWriteUtil.writeObjToFile(log, file);
            }
            catch (IOException e) {
                System.out.println("\u5411\u6587\u4ef6\uff1a" + file + "\u4e2d\u5199\u5165\u65e5\u5fd7\uff1a{}" + log + "\u9519\u8bef,\u9519\u8bef\u7684\u4fe1\u606f\u4e3a:" + e.getMessage());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] read(String file) throws FileNotFoundException {
        Object[] objectArray;
        File file1 = new File(file);
        if (!file1.exists()) {
            throw new NotFoundFileException("{} not exist", file);
        }
        BufferedReader reader = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            objectArray = reader.lines().toArray();
        }
        catch (Throwable throwable) {
            StreamCloseUtils.close(reader);
            StreamCloseUtils.close(fileReader);
            throw throwable;
        }
        StreamCloseUtils.close(reader);
        StreamCloseUtils.close(fileReader);
        return objectArray;
    }

    public static int getTotalLines(File file) {
        int n;
        FileReader in = null;
        LineNumberReader reader = null;
        try {
            in = new FileReader(file);
            reader = new LineNumberReader(in);
            String s = reader.readLine();
            int lines = 0;
            while (s != null) {
                ++lines;
                s = reader.readLine();
            }
            n = lines;
        }
        catch (IOException e) {
            try {
                throw new CustomException(e);
            }
            catch (Throwable throwable) {
                StreamCloseUtils.close(reader);
                StreamCloseUtils.close(in);
                throw throwable;
            }
        }
        StreamCloseUtils.close(reader);
        StreamCloseUtils.close(in);
        return n;
    }

    public static String readAppointedLineNumber(File sourceFile, int lineNumber) {
        String string;
        FileReader in = null;
        LineNumberReader reader = null;
        try {
            in = new FileReader(sourceFile);
            reader = new LineNumberReader(in);
            if (lineNumber < 0 || lineNumber > FileReadAndWriteUtil.getTotalLines(sourceFile)) {
                throw new CustomException("\u4e0d\u5728\u6587\u4ef6\u7684\u884c\u6570\u8303\u56f4\u4e4b\u5185");
            }
            string = reader.readLine();
        }
        catch (IOException e) {
            try {
                throw new CustomException(e);
            }
            catch (Throwable throwable) {
                StreamCloseUtils.close(reader);
                StreamCloseUtils.close(in);
                throw throwable;
            }
        }
        StreamCloseUtils.close(reader);
        StreamCloseUtils.close(in);
        return string;
    }
}

