/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.doudou.base.exception.CustomException;
import top.doudou.base.exception.ExceptionUtils;
import top.doudou.base.stream.StreamCloseUtils;
import top.doudou.base.util.FastAssert;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static boolean exist(File file) {
        return file.exists();
    }

    public static boolean exist(String filePath) {
        return new File(filePath).exists();
    }

    public static boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public static boolean isDirectory(String filePath) {
        return new File(filePath).isDirectory();
    }

    public static File getParentFile(File file) {
        return file.getParentFile();
    }

    public static boolean createNewFile(File file) throws IOException {
        if (FileUtil.exist(file)) {
            return file.createNewFile();
        }
        if (FileUtil.isDirectory(file)) {
            throw new CustomException("file is directory\uff0cnot a file");
        }
        File parentFile = file.getParentFile();
        parentFile.mkdirs();
        return file.createNewFile();
    }

    public static boolean touch(File file) throws IOException {
        return FileUtil.touch(file, false);
    }

    public static boolean touch(File file, boolean isDirectory) throws IOException {
        if (FileUtil.exist(file)) {
            return true;
        }
        if (isDirectory || FileUtil.isDirectory(file)) {
            return file.mkdirs();
        }
        return FileUtil.createNewFile(file);
    }

    public static String getSuffix(File file) {
        if (FileUtil.isDirectory(file)) {
            throw new CustomException("\u6587\u4ef6\u4e3a\u6587\u4ef6\u5939\uff0c\u4e0d\u80fd\u83b7\u53d6\u6587\u4ef6\u7684\u540e\u7f00");
        }
        String fileName = file.getName();
        if (fileName == null) {
            return null;
        }
        if (fileName.length() == 0) {
            return fileName;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String getSuffix(String filePath) {
        return FileUtil.getSuffix(new File(filePath));
    }

    public static String getPrefix(File file) {
        String fileName = file.getName();
        if (file.isDirectory()) {
            return fileName;
        }
        if (null == fileName) {
            return null;
        }
        int len = fileName.length();
        if (0 == len) {
            return fileName;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    public static String getPrefix(String filePath) {
        return FileUtil.getPrefix(new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean copy(File sourceFile, File targetFile) {
        boolean success = true;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(sourceFile);
            out = new FileOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer);
            }
        }
        catch (FileNotFoundException e) {
            success = false;
            StreamCloseUtils.close(in);
            StreamCloseUtils.close(out);
        }
        catch (IOException e2) {
            success = false;
            {
                catch (Throwable throwable) {
                    StreamCloseUtils.close(in);
                    StreamCloseUtils.close(out);
                    throw throwable;
                }
            }
            StreamCloseUtils.close(in);
            StreamCloseUtils.close(out);
        }
        StreamCloseUtils.close(in);
        StreamCloseUtils.close(out);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFiles(List<File> srcFiles, File zipFile) {
        block11: {
            if (CollectionUtils.isEmpty(srcFiles)) {
                log.error("\u9700\u8981\u538b\u7f29\u7684\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a,\u6545\u76f4\u63a5\u8fd4\u56de");
                return;
            }
            if (!zipFile.exists()) {
                try {
                    zipFile.createNewFile();
                }
                catch (IOException e) {
                    throw new CustomException("\u538b\u7f29\u540e\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u538b\u7f29\u540e\u7684\u6587\u4ef6\u5931\u8d25");
                }
            }
            FileOutputStream fileOutputStream = null;
            ZipOutputStream zipOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(zipFile);
                zipOutputStream = new ZipOutputStream(fileOutputStream);
                for (int i = 0; i < srcFiles.size(); ++i) {
                    int len;
                    File item = srcFiles.get(i);
                    fileInputStream = new FileInputStream(item);
                    zipOutputStream.putNextEntry(new ZipEntry(item.getName()));
                    byte[] buffer = new byte[1024];
                    while ((len = fileInputStream.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                }
                StreamCloseUtils.close(zipOutputStream);
            }
            catch (IOException e) {
                log.error(ExceptionUtils.toString(e));
                break block11;
            }
            finally {
                StreamCloseUtils.close(zipOutputStream);
                StreamCloseUtils.close(fileInputStream);
                StreamCloseUtils.close(fileOutputStream);
            }
            StreamCloseUtils.close(fileInputStream);
            StreamCloseUtils.close(fileOutputStream);
        }
    }

    public static void move(File sourceFile, String catalogue, String fileName) {
        if (!FileUtil.exist(sourceFile)) {
            throw new CustomException("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (!FileUtil.exist(catalogue)) {
            new File(catalogue).mkdirs();
        }
        File fileNew = new File(catalogue + File.separator + fileName);
        try {
            FileUtils.moveFile((File)sourceFile, (File)fileNew);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutFile(File bigFile, String storageLocation, int num) {
        if (!FileUtil.exist(bigFile)) {
            throw new CustomException("\u5927\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        if (!FileUtil.exist(storageLocation)) {
            new File(storageLocation).mkdirs();
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(bigFile);
            byte[] b = new byte[num];
            int len = 0;
            int fileNum = 1;
            while ((len = fis.read(b)) != -1) {
                String filePrefix = FileUtil.getPrefix(bigFile);
                String fileSuffix = FileUtil.getSuffix(bigFile);
                FileOutputStream fos = new FileOutputStream(storageLocation + "\\\\" + filePrefix + "_" + fileNum + "." + fileSuffix);
                fos.write(b, 0, len);
                StreamCloseUtils.close(fos);
                ++fileNum;
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamCloseUtils.close(fis);
                throw throwable;
            }
            StreamCloseUtils.close(fis);
        }
        StreamCloseUtils.close(fis);
    }

    public static File saveUrlToFile(String url, String filePath, String fileName) throws IOException {
        File temp;
        File file;
        FastAssert.notEmpty(filePath, "filePath is null");
        FastAssert.notEmpty(fileName, "fileName is null");
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        if (!(file = new File(filePath)).exists()) {
            FileUtil.touch(file, true);
        }
        if (!(temp = new File(filePath + fileName)).exists()) {
            FileUtil.createNewFile(temp);
        }
        InputStream input = new URL(url).openStream();
        FileUtils.copyInputStreamToFile((InputStream)input, (File)temp);
        return temp;
    }

    public static File zipFile(String zipFilePath, String zipFileName, Map<String, InputStream> mapInputStream) throws IOException {
        if (MapUtils.isEmpty(mapInputStream)) {
            log.error("mapInputStream  \u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        File file = new File(zipFilePath);
        if (!file.exists()) {
            FileUtil.touch(file, true);
        }
        File retFile = new File(zipFilePath + File.separator + zipFileName + ".zip");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(retFile);
            ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);
            mapInputStream.forEach((k, v) -> {
                if (null != v) {
                    try {
                        int len;
                        ZipEntry zipEntry = new ZipEntry((String)k);
                        zipOut.putNextEntry(zipEntry);
                        byte[] buffer = new byte[1024];
                        while ((len = v.read(buffer)) > 0) {
                            zipOut.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        log.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25");
                        e.printStackTrace();
                    }
                }
            });
            StreamCloseUtils.close(zipOut);
        }
        catch (IOException e) {
            log.error("\u538b\u7f29\u6587\u4ef6\u5931\u8d25");
            e.printStackTrace();
        }
        return retFile;
    }
}

