/*
 * Decompiled with CFR 0.152.
 */
package top.doudou.base.web;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import top.doudou.base.builder.JsonBuilder;
import top.doudou.base.exception.ExceptionUtils;

public class ResponseUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtil.class);

    public static void write(HttpServletResponse response, Object result) {
        ResponseUtil.write(response, HttpStatus.OK, result);
    }

    public static void write(HttpServletResponse response, HttpStatus status, Object result) {
        if (null == response) {
            return;
        }
        if (null == status) {
            status = HttpStatus.OK;
        }
        if (null == result) {
            result = "";
        }
        try {
            response.setStatus(status.value());
            response.setHeader("Content-Type", "application/json");
            response.setHeader("Access-Control-Allow-Origin", "*");
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(JsonBuilder.gson().toJson(result));
            response.getWriter().flush();
        }
        catch (IOException e) {
            log.error(ExceptionUtils.toString(e));
        }
    }
}

