package top.doudou.base.api.version;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import top.doudou.base.api.version.annotation.ApiVersion;

import java.lang.reflect.Method;

/**
 * @Description Handler
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-22 16:55
 */
public class ApiVersionHandlerMapping extends RequestMappingHandlerMapping {

    /**
     * 所有的controller类都会经过这个方法
     * @param handlerType
     * @return
     */
    @Override
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        ApiVersion annotation = AnnotationUtils.findAnnotation(handlerType, ApiVersion.class);
        return createCondition(annotation);
    }

    /**
     * 所有controller中的方法都会经过这个方法
     * @param method
     * @return
     */
    @Override
    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        ApiVersion annotation = AnnotationUtils.findAnnotation(method, ApiVersion.class);
        if (annotation == null) {
            annotation = AnnotationUtils.findAnnotation(method.getDeclaringClass(), ApiVersion.class);
        }
        return createCondition(annotation);
    }

    private RequestCondition<ApiVersionRequestCondition> createCondition(ApiVersion version) {
        return version == null ? ApiVersionRequestCondition.DEFAULT_API_VERSION : new ApiVersionRequestCondition(version.value());
    }
}
