package top.doudou.base.api.version.config;

import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import top.doudou.base.api.version.ApiVersionHandlerMapping;

/**
 * @Description 不添加@Configuration注解，避免自动开启
 *               配置使用自定义的映射处理器
 * @version: 1.0
 * @Created 傻男人 <244191347@qq.com>
 * @Date 2021-10-25 9:35
 */
public class ApiVersionWebConfiguration implements WebMvcRegistrations {

    /**
     * 使用自定义的ApiVersion映射处理器代替MVC默认的映射处理器
     * @return
     */
    @Override
    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new ApiVersionHandlerMapping();
    }
}
