package top.doudou.base.build;

import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import top.doudou.base.config.RequestDecorator;
import top.doudou.base.properties.ExecutorProperties;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;

/**
 * @Description  线程池构建
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2021-09-15 11:17
 * @Version V1.0
 */
@Slf4j
public class ExecutorBuilder {

    public static Executor builder(String beanName, int corePoolSize, int maxPoolSize, int queueCapacity, int keepAliveSeconds, String threadNamePrefix, RejectedExecutionHandler rejectedExecutionHandler,boolean allowCoreThreadTimeOut){
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setKeepAliveSeconds(keepAliveSeconds);
        executor.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        executor.setRejectedExecutionHandler(rejectedExecutionHandler);
        executor.setThreadNamePrefix(threadNamePrefix);
        executor.setQueueCapacity(queueCapacity);
        executor.setTaskDecorator(new RequestDecorator());
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(60);
        executor.initialize();
        log.info("Executor info --> beanName:{},corePoolSize:{},maxPoolSize:{},queueCapacity:{},keepAliveSeconds:{},threadNamePrefix:{},rejectedExecutionHandler:{} 成功",
                beanName,executor.getCorePoolSize(),
                executor.getMaxPoolSize(),
                queueCapacity,
                executor.getKeepAliveSeconds(),
                executor.getThreadNamePrefix(),
                rejectedExecutionHandler.toString());
        return executor;
    }

    public static Executor builder(String beanName, ExecutorProperties properties){
        return builder(beanName,properties.getCorePoolSize(),properties.getMaxPoolSize(),
                properties.getCapacity(),properties.getKeepAliveSecond(),properties.getThreadNamePrefix(),properties.getRejectHandler().getRejectedExecutionHandler(),properties.isAllowCoreThreadTimeOut());
    }

    public static Executor builder(ExecutorProperties properties){
        return builder(null,properties.getCorePoolSize(),properties.getMaxPoolSize(),
                properties.getCapacity(),properties.getKeepAliveSecond(),properties.getThreadNamePrefix(),properties.getRejectHandler().getRejectedExecutionHandler(),properties.isAllowCoreThreadTimeOut());
    }

}
