package top.doudou.base.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.task.TaskExecutor;
import top.doudou.base.build.ExecutorBuilder;
import top.doudou.base.constant.PropertiesConstant;
import top.doudou.base.properties.ExecutorProperties;
import top.doudou.base.util.IpHelper;
import top.doudou.core.system.SystemMonitorUtil;

import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * @Description
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-12-01 11:17
 * @Version V1.0
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(ExecutorProperties.class)
public class InitThreadPool {

    @Autowired
    private ExecutorProperties executorProperties;

    @Autowired
    private ApplicationContext context;

    @Bean
    @Primary
    public TaskExecutor executorService(){
        log.debug("[Async-Executor-init] - Initialization info - {}", executorProperties);
        if(StringUtils.isBlank(executorProperties.getThreadNamePrefix())){
            String applicationName = context.getEnvironment().getProperty(PropertiesConstant.APPLICATION_NAME);
            if(StringUtils.isBlank(applicationName)){
                applicationName = "andoudou_top";
            }
            executorProperties.setThreadNamePrefix("async-"+applicationName+"-pool-");
        }
        return (TaskExecutor) ExecutorBuilder.builder("executorService",executorProperties);

    }

    @Bean("initAsyncDefaultPool")
    public Executor initAsyncDefaultPool() {
        int cpuCount = SystemMonitorUtil.getCpuCount();
        String applicationName = context.getEnvironment().getProperty(PropertiesConstant.APPLICATION_NAME);
        if(StringUtils.isBlank(applicationName)){
            applicationName = "default";
        }
        return ExecutorBuilder.builder("initAsyncDefaultPool",cpuCount,cpuCount*2,200,0,
                "async-"+applicationName+"-default-pool-",
                new ThreadPoolExecutor.CallerRunsPolicy(),
                false);
    }

}
