package top.doudou.base.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

/**
 * @Description request的装饰类
 * @Author 傻男人 <244191347@qq.com>
 * @Date 2020-11-18 11:20
 * @Version V1.0
 */
@Slf4j
public class RequestDecorator implements TaskDecorator {
 
    @Override
    public Runnable decorate(Runnable runnable) {
        try{
            RequestAttributes request = RequestContextHolder.currentRequestAttributes();
            RequestContextHolder.setRequestAttributes(request,true);
        }catch (Exception e){
            RequestContextHolder.resetRequestAttributes();
        }
        return ()-> runnable.run();
    }
}