package top.doudou.base.properties;


import com.google.common.collect.Sets;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author  傻男人<244191347@qq.com>
 * @Date: 2020/8/25 14:06
 * @Version: 1.0
 * @Description: 请求日志的配置
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "custom.filter")
public class CustomFilterProperties {

    /**
     * xss过滤排除的url
     */
    private Set<String> excludeXssUrl = Sets.newHashSet();


    /**
     * ip白名单(黑名单与白名单不能同时存在)
     */
    private Set<String> allow = Sets.newHashSet();

    /**
     * ip黑名单(黑名单与白名单不能同时存在)
     */
    private Set<String> deny = Sets.newHashSet();
}