package top.doudou.base.respond;

import com.google.gson.Gson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 响应数据
 *
 * @author  傻男人<244191347@qq.com>
 * @since 1.0.0
 */
@Data
@ApiModel(value = "Result<T>", description = "通用响应")
public class Result<T> implements Serializable {

    private static final long serialVersionUID = 2261554643166465633L;
    /**
     * 编码：0表示成功，其他值表示失败
     */
    @ApiModelProperty(value = "编码：0表示成功，其他值表示失败")
    private int code;

    /**
     * 请求序列号
     */
    @ApiModelProperty(value = "请求序列号")
    private String requestCode;

    /**
     * 消息内容
     */
    @ApiModelProperty(value = "消息内容")
    private String message;
    /**
     * 响应数据
     */
    @ApiModelProperty(value = "响应数据")
    private T data;

    /**
     * 异常的信息
     */
    @ApiModelProperty(value = "异常的信息")
    private String errorMsg;

    /**
     * 时间戳
     */
    @ApiModelProperty(value = "时间戳")
    private Long timestamp = System.currentTimeMillis();

    public Result(){
    }

    public static <E> Result<E> ok() {
        return new Result<>().success();
    }

    public static <E> Result ok(E data) {
        return new Result<>().success(data);
    }

    public Result success() {
        this.code = 0;
        this.setMessage("success");
        return this;
    }

    public Result success(T data) {
        this.success();
        this.setData(data);
        return this;
    }

    public static <E> Result<E> fail() {
        return new Result<>().error();
    }

    public static <E> Result fail(String message) {
        return new Result<>().error(message);
    }

    public static <T> Result fail(String message,T data) {
        Result result = new Result();
        result.setMessage(message);
        result.setData(data);
        result.code = 1000;
        return result;
    }

    public Result error() {
        this.code = 1000;
        this.message = "error";
        return this;
    }

    public Result<T> error(int code) {
        this.code = code;
        this.message = "error";
        return this;
    }


    public static Result error(int code, String msg) {
        Result result = new Result();
        result.setCode(code);
        result.setMessage(msg);
        return result;
    }

    public static <T extends Exception>Result error(int code,String message, T e) {
        Result result = new Result();
        result.setMessage(message);
        result.setErrorMsg(e.getMessage());
        result.setCode(code);
        return result;
    }

    public static Result error(int code,String message,Object obj){
        Result result = new Result();
        result.code = code;
        result.message = message ;
        result.errorMsg = new Gson().toJson(obj);
        return result;
    }

    public static Result error(String message, String errorMsg) {
        Result result = new Result();
        result.setMessage(message);
        result.setErrorMsg(errorMsg);
        result.setCode(1000);
        return result;
    }

    public Result<T> error(String msg) {
        this.message = msg;
        this.code = 1000;
        return this;
    }
}

